{include file="orderforms/{$carttpl}/common.tpl"}
<div id="order-standard_cart">
	<div {if !$themesettings.general.themelayout}class="main-container-nosidebar mx-auto"{/if}>
		<div class="row">
			<div class="col-md-12">
				{if $totalServiceCount == 0}
					<div class="alert-lg no-data no-border">
						<div class="icon">
							<i class="fad fa-thumbs-up"></i>
						</div>
						<div class="text">
							<h4>{lang key='renewService.noServices'}</h4>
						</div>
						<a href="{$WEB_ROOT}/clientarea.php" class="btn btn-default">
							{$LANG.orderForm.returnToClientArea}
						</a>
					</div>
				{else}
					<div class="header-lined">
						<div>
							<h1>
								{if $totalResults > 1}{lang key='renewService.titlePlural'}{else}{lang key='renewService.titleSingular'}{/if}
							</h1>
							{if $totalResults > 5}
								<div class="search-group">
									<input id="serviceRenewalFilter" type="search" class="service-renewals-filter form-control" placeholder="{lang key='renewService.searchPlaceholder'}">
								</div>
							{/if}
						</div>
					</div>
					
					<div class="row ajaxcart_cont">
						<div class="col-lg-8">
							<button id="hideShowServiceRenewalButton" class="btn btn-sm btn-default mb-3 service-renewals-quick-filter">
								<span class="to-hide">
									{lang key='renewService.hideShowServices.hide'}
								</span>
								<span class="to-show">
									{lang key='renewService.hideShowServices.show'}
								</span>
							</button>
							
							{if $totalResults < $totalServiceCount}
								<div class="text-center mb-3">
									{lang key='renewService.showingServices' showing=$totalResults totalCount=$totalServiceCount}
									<a id="linkShowAll" href="{routePath('service-renewals')}">
										{lang key='domainRenewal.showAll'}
									</a>
								</div>
							{/if}
							<div id="serviceRenewals" class="service-renewals">
								{include file="orderforms/{$carttpl}/service-renewal-item.tpl" renewableItems=$renewableServices prefix=''}
							</div>
						</div>
						<div class="col-lg-4">
							<div  id="sidebar">
								<div class="sidebar__inner blocks cartsummary">
									<div>
										<div class="order-summary">
											<div class="loader" id="orderSummaryLoader">
												<i class="fad fa-circle-notch fa-spin fa-2x"></i>
											</div>
											<h2><i class="fal fa-shopping-cart text-primary"></i>&nbsp;{lang key='ordersummary'}</h2>
											<div class="summary-container-outer">
												<div class="summary-container" id="producttotal"></div>
											
												<div class="text-center">
													<a id="btnGoToCart" class="btn btn-primary btn-block btn-lg" href="{$WEB_ROOT}/cart.php?a=view">
														{lang key='viewcart'}
													</a>
												</div>
											</div>
										</div>

									</div>
								</div>
							</div>
						</div>
					</div>
				{/if}
			</div>
		</div>
	</div>
</div>

<form id="removeRenewalForm" method="post" action="{$WEB_ROOT}/cart.php" data-renew-type="service">
	<input type="hidden" name="a" value="remove">
	<input type="hidden" name="r" value="" id="inputRemoveItemType">
	<input type="hidden" name="i" value="" id="inputRemoveItemRef">
	<input type="hidden" name="rt" value="service" id="inputRemoveItemRenewalType">
	<div class="modal fade modal-remove-item" id="modalRemoveItem" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header d-block">
					<h4 class="modal-title m-0">
						<button type="button" class="close" data-dismiss="modal" aria-label="{lang key='orderForm.close'}">
							<span aria-hidden="true">&times;</span>
						</button>
						<span>{lang key='orderForm.removeItem'}</span>
					</h4>
				</div>
				<div class="modal-body">
					{lang key='cartremoveitemconfirm'}
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">{lang key='no'}</button>
					<button type="submit" class="btn btn-primary">{lang key='yes'}</button>
				</div>
			</div>
		</div>
	</div>
</form>

<script>recalculateRenewalTotals();</script>

<script type="text/javascript" src="{$WEB_ROOT}/templates/orderforms/{$carttpl}/js/ResizeSensor.js"></script>
<script type="text/javascript" src="{$WEB_ROOT}/templates/orderforms/{$carttpl}/js/jquery.sticky-sidebar.min.js"></script>

<script>
    jQuery('#sidebar').stickySidebar({
        topSpacing: 90,
        bottomSpacing: 60,
        minWidth: 992,
        containerSelector: '.ajaxcart_cont',
        innerWrapperSelector: '.sidebar__inner'
    });
</script>
