{if $producttotals}
	<span class="product-group fw-500">{$producttotals.productinfo.groupname}</span>
    <ul class="cart-summry-list pt-0 pb-1 mb-2">
        <li class="list-item">
			<span class="product-name mb-0 item-name">{if $producttotals.allowqty && $producttotals.qty > 1}{$producttotals.qty} x {/if}{$producttotals.productinfo.name}</span>
			<span class="item-value">{$producttotals.pricing.baseprice}</span>
		</li>
    </ul>
	
	{if $producttotals.configoptions}
		<ul class="cart-summry-list">
			{foreach $producttotals.configoptions as $configoption}
				{if $configoption}
					<li class="list-item">
						<span class="item-name">&nbsp;&raquo; {$configoption.name}: {$configoption.optionname}</span>
						<span class="item-value">{$configoption.recurring}{if $configoption.setup} + {$configoption.setup} {$LANG.ordersetupfee}{/if}</span>
					</li>
				{/if}
			{/foreach}
		</ul>
	{/if}

	{if $producttotals.addons}
		<ul class="cart-summry-list">
			<li class="list-item list-item-title border-bottom fw-500 mb-2">{$LANG.cartaddons}</li>
			{foreach $producttotals.addons as $addon}
				<li class="list-item">
					<span class="item-name">{$addon.name}</span>
					<span class="item-value">{$addon.recurring}</span>
				</li>
			{/foreach}
		</ul>
	{/if}

    {if $producttotals.pricing.setup || $producttotals.pricing.recurring || $producttotals.pricing.addons}
        <div class="summary-totals">
            {if $producttotals.pricing.setup}
                <div class="clearfix">
                    <span class="pull-left float-left">{$LANG.cartsetupfees}:</span>
                    <span class="pull-right float-right">{$producttotals.pricing.setup}</span>
                </div>
            {/if}
            {foreach from=$producttotals.pricing.recurringexcltax key=cycle item=recurring}
                <div class="clearfix">
                    <span class="pull-left float-left">{$cycle}:</span>
                    <span class="pull-right float-right">{$recurring}</span>
                </div>
            {/foreach}
            {if $producttotals.pricing.tax1}
                <div class="clearfix">
                    <span class="pull-left float-left">{$carttotals.taxname} @ {$carttotals.taxrate}%:</span>
                    <span class="pull-right float-right">{$producttotals.pricing.tax1}</span>
                </div>
            {/if}
            {if $producttotals.pricing.tax2}
                <div class="clearfix">
                    <span class="pull-left float-left">{$carttotals.taxname2} @ {$carttotals.taxrate2}%:</span>
                    <span class="pull-right float-right">{$producttotals.pricing.tax2}</span>
                </div>
            {/if}
        </div>
    {/if}

    <div class="total-due-today">
		<span class="text-muted">{$LANG.ordertotalduetoday}</span>
        <span class="amt">{$producttotals.pricing.totaltoday}</span>
    </div>
{elseif !empty($renewals) || !empty($serviceRenewals)}
    {if !empty($serviceRenewals)}
        {if !empty($carttotals.renewalsByType.services)}
            <span class="product-name">{lang key='renewService.titleAltPlural'}</span>
            {foreach $carttotals.renewalsByType.services as $serviceId => $serviceRenewal}
                <div class="clearfix" id="cartServiceRenewal{$serviceId}">
                    <div class="pull-left float-left">
                        <div>
                            {$serviceRenewal.name}
                        </div>
                        <div>
                            {$serviceRenewal.domainName}
                        </div>
                    </div>
                    <div class="pull-right float-right">
                        <div>
                            {$serviceRenewal.billingCycle}
                        </div>
                        <div>
                            {$serviceRenewal.recurringBeforeTax}
                            <a onclick="removeItem('r','{$serviceId}','service'); return false;" href="#" id="linkCartRemoveServiceRenewal{$serviceId}">
                                <i class="fas fa-fw fa-trash-alt"></i>
                            </a>
                        </div>
                    </div>
                </div>
            {/foreach}
        {/if}
        {if !empty($carttotals.renewalsByType.addons)}
            <span class="product-name">{lang key='renewServiceAddon.titleAltPlural'}</span>
            {foreach $carttotals.renewalsByType.addons as $serviceAddonId => $serviceAddonRenewal}
                <div class="clearfix" id="cartServiceAddonRenewal{$serviceAddonId}">
                    <div class="pull-left float-left">
                        <div>
                            {$serviceAddonRenewal.name}
                        </div>
                        <div>
                            {$serviceAddonRenewal.domainName}
                        </div>
                    </div>
                    <div class="pull-right float-right">
                        <div>
                            {$serviceAddonRenewal.billingCycle}
                        </div>
                        <div>
                            {$serviceAddonRenewal.recurringBeforeTax}
                            <a onclick="removeItem('r','{$serviceAddonId}','addon'); return false;" href="#" id="linkCartRemoveServiceAddonRenewal{$serviceAddonId}">
                                <i class="fas fa-fw fa-trash-alt"></i>
                            </a>
                        </div>
                    </div>
                </div>
            {/foreach}
        {/if}
    {elseif !empty($renewals) && !empty($carttotals.renewalsByType.domains)}
        <span class="product-name">{lang key='domainrenewals'}</span>
        {foreach $carttotals.renewalsByType.domains as $domainId => $renewal}
            <div class="clearfix" id="cartDomainRenewal{$domainId}">
                <span class="pull-left float-left">
                    {$renewal.domain} - {$renewal.regperiod} {if $renewal.regperiod == 1}{lang key='orderForm.year'}{else}{lang key='orderForm.years'}{/if}
                </span>
                <span class="pull-right float-right">
                    {$renewal.priceBeforeTax}
                    <a onclick="removeItem('r','{$domainId}','domain'); return false;" href="#" id="linkCartRemoveDomainRenewal{$domainId}">
                        <i class="fas fa-fw fa-trash-alt"></i>
                    </a>
                </span>
            </div>
            {if $renewal.dnsmanagement}
                <div class="clearfix">
                    <span class="pull-left float-left">+ {lang key='domaindnsmanagement'}</span>
                </div>
            {/if}
            {if $renewal.emailforwarding}
                <div class="clearfix">
                    <span class="pull-left float-left">+ {lang key='domainemailforwarding'}</span>
                </div>
            {/if}
            {if $renewal.idprotection}
                <div class="clearfix">
                    <span class="pull-left float-left">+ {lang key='domainidprotection'}</span>
                </div>
            {/if}
            {if $renewal.hasGracePeriodFee}
                <div class="clearfix">
                    <span class="pull-left float-left">+ {lang key='domainRenewal.graceFee'}</span>
                </div>
            {/if}
            {if $renewal.hasRedemptionGracePeriodFee}
                <div class="clearfix">
                    <span class="pull-left float-left">+ {lang key='domainRenewal.redemptionFee'}</span>
                </div>
            {/if}

        {/foreach}
    {/if}
    <div class="summary-totals">
        <div class="clearfix">
            <span class="pull-left">{lang key='ordersubtotal'}:</span>
            <span class="pull-right">{$carttotals.subtotal}</span>
        </div>
        {if ($carttotals.taxrate && $carttotals.taxtotal) || ($carttotals.taxrate2 && $carttotals.taxtotal2)}
            {if $carttotals.taxrate}
                <div class="clearfix">
                    <span class="pull-left float-left">{$carttotals.taxname} @ {$carttotals.taxrate}%:</span>
                    <span class="pull-right float-right">{$carttotals.taxtotal}</span>
                </div>
            {/if}
            {if $carttotals.taxrate2}
                <div class="clearfix">
                    <span class="pull-left float-left">{$carttotals.taxname2} @ {$carttotals.taxrate2}%:</span>
                    <span class="pull-right float-right">{$carttotals.taxtotal2}</span>
                </div>
            {/if}
        {/if}
    </div>
    <div class="total-due-today">
		<span class="text-muted">{lang key='ordertotalduetoday'}</span>
        <span class="amt">{$carttotals.total}</span>
    </div>
{/if}
