class faqs {
    static get toolbox() {
        return {
            title: 'FAQs',
            icon: '<i class="fas fa-question-circle"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }, 
			subtitle: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>FAQs<a class="sec-docs" href="https://docs.thememetro.com/#Sec-Faqs" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control wsinput" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>				
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
						  <label>Background Type</label>
						  <select type="select" class="form-control blockbgcolor">
							<option value="">None</option>
							<option value="light">Light</option>
						   </select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Border</label>
							<select type="select" class="form-control blockborders">
							  <option value="">None</option>
							  <option value="border-top">Top Border</option>
							  <option value="border-bottom">Bottom Border</option>
							</select>
						</div>
					</div>
				  <div class="col-md-6">
					<div class="form-group">
						<label>Padding Top</label>
						<select type="select" class="form-control blocktheight">
						  <option value="">Default</option>
						  <option value="1">60px</option>
						  <option value="2">30px</option>
						  <option value="3">None</option>
						</select>
					</div>
				  </div>
				  <div class="col-md-6">
					 <div class="form-group">
						<label>Padding Bottom</label>
						<select type="select" class="form-control blockbheight">
						  <option value="">Default</option>
						  <option value="1">60px</option>
						  <option value="2">30px</option>
						  <option value="3">None</option>
						</select>
					</div>
				  </div>					   
				</div>
			</div>
			<div class="heading">
				<h5>FAQs Type</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Type</label>
					<select type="select" class="form-control acstyles">
					  <option value="">Type 1</option>
					  <option value="1">Type 2</option>
					  <option value="2">Type 3</option>
					</select>
				</div>
			</div>			
			<div class="vjsGrid"></div>
		</div>
	</div>
</div>
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit FQA Item</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
				<div class="form-group">
					<label>Item Title</label>
					<input type="text" class="form-control faq_title">
				</div>
				<div class="form-group">
					<label>Item Description</label>
					<textarea type="text" type="text" rows="7" class="form-control faq_description"></textarea>
				</div>
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);
		
        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);		
       	const title = this.data && this.data.title ? this.data.title : "";
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const blocktheight = this.data && this.data.btheight ? this.data.btheight : "";
        $(wrapper).find(".blocktheight").val(blocktheight);
        const blockbheight = this.data && this.data.bbheight ? this.data.bbheight : "";
        $(wrapper).find(".blockbheight").val(blockbheight);		
        const acstyles = this.data && this.data.faqsStyle ? this.data.faqsStyle : "";
        $(wrapper).find(".acstyles").val(acstyles);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the item <b> \"" + args.item.Title + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item);
                }
            },
			rowRenderer: function(item) {
				var $cButtons = $("<td>").addClass("jsgrid-cell jsgrid-control-field jsgrid-align-center").attr("width", "50px").append($("<button>").addClass("jsgrid-button jsgrid-delete-button").attr("type", "button").attr("title", "Delete"));
				
				$cButtons.on("click", function() {
					showDetailsDialog("Delete", {});
				});
				
				var faqs = item;
				var $config = $("<div>").addClass("panel panel-default")
                .append($("<div class='panel-heading'><h3 class='panel-title'>").html("" + faqs.Title))
				.append($("<div class='panel-body'>").html("" + faqs['List Items']));
				
				return $("<tr>")
					.append($("<td>").addClass("jsgrid-cell grid-info-block custom-grid jsgrid-align-left").attr("width", "400px").append($config))
					.append($cButtons);
			},
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {name: "Title", title: "FAQs", type: "text", width: 400, validate: "required"},
                {name: "List Items", title: "Answer/Description", type: "textarea", visible: false, sorting: false, validate: "required"},
                //{type: "control"}
                //changed input to buttons
                {type: "control", editButton: false,	
                 _createGridButton: function(cls, tooltip, clickHandler) {
                      var grid = this._grid;

                      return $("<button>").addClass(this.buttonClass)
                         .addClass(cls)
                           .attr({
                                type: "button",
                                title: tooltip
                               })
                            .on("click", function(e) {
                                //clickHandler(grid, e);
								showDetailsDialog("Add", {});
                            });
                     },

                    editValue: function() {
                       return "";
                   }				
				
				
              } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

		var showDetailsDialog = function (dialogType, faqs) {
			var isNew = dialogType === "Add";

			if (isNew) {
				faqs = {
					Title: '',
					'List Items': ''
				};
			}
			
			$(wrapper).find(".faq_title").val(faqs.Title);

			$(wrapper).find('.modal').off('shown.bs.modal').on('shown.bs.modal', function () {
				var modalId = $(this).attr('id');
				var $faqDescription = $('#' + modalId).find('.faq_description');

				if (!$faqDescription.next('.trumbowyg-box ').length) {
					$faqDescription.trumbowyg({
						semantic: false,
						btns: [
							['strong', 'em', 'del', 'underline'],
							['unorderedList', 'orderedList'],
							['viewHTML']
						],
					});
				}
				$faqDescription.trumbowyg('html', faqs['List Items']);
			});


			formSubmitHandler = function () {
				saveFaqs(faqs, dialogType === "Add");
			};
			
			$(wrapper).find(".modal").modal('show');
		};


        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .faq_title").val() === '') {
				alert('Title is required.');
				e.preventDefault();
			} else if ($(".ce-block--focused .faq_description").val() === "") {
				alert('Description is required.');
				e.preventDefault();
			} else {
				formSubmitHandler();
			}
        });
		
        var saveFaqs = function (faqs, isNew) {
            $.extend(faqs, {
				Title: $(wrapper).find(".faq_title").val(),
				'List Items': $(wrapper).find(".faq_description").val()
            });
            $(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", faqs);
            $(wrapper).find(".modal").modal('hide');
        };

        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });
		
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(title);
        }, 200);
		
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
            "table": items,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "btheight": $(blockContent).find(".blocktheight").val(),
            "bbheight": $(blockContent).find(".blockbheight").val(),			
            "faqsStyle": $(blockContent).find(".acstyles").val(),
			"caption": $(blockContent).find(".sectioncaption").val(),
            "title": $(blockContent).find(".wsinput").val(),
			"subtitle": subtitle,
			"sechidden": sechidden
        };
    }
}