class domainsearch {
    static get toolbox() {
        return {
            title: 'Domain Search (Deprecate)',
            icon: '<i class="fas fa-search"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render()
    {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Domain Search<span class="sec-docs text-danger" href="#" data-container="body" data-toggle="popover" data-trigger="hover" data-html="true" data-content="This section will be removed in the upcoming release. You will need to migrate the contents into the <strong>Banner Domain</strong> section.">Deprecated</span></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="sec_groups">
			   <div class="form-group">
					<label>Doamin Search Type</label>
					<select type="select" class="form-control dsis">
						<option value="">Default</option>
						<option value="1">Full Width</option>
					</select>
					<span class="help-block">This will only apply if the section is the first section on the page.</span>
			   </div>
			</div>
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Title</label>
						<input type="text" class="form-control setitle" placeholder="i.e., Find your new domain name" value="" />
					</label>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
						<option value="">None</option>
						<option value="bg-primary">Primary</option>
						<option value="light">Light</option>
						<option value="dark">Dark</option>
						<option value="imgbg">Image</option>									
					</select>
				</div>
				<div class="simginput">
				   <div class="form-group">
					<label>Background Image</label>
					<div class="input-group">
						<input type="text" id="${this.data.id}-bgsbgcolor" class="form-control bgsbgcolor" value="" />
						<span onclick="PageGraphics('${this.data.id}-bgsbgcolor')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
					</div>				 
					<span class="help-block">Leave this fled empty if you want use theme default image in the backgound.</span>
				   </div>
				</div>
				<div class="sborderinput">
				 <div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					 </select>
				  </div>
				</div>
			</div>
			<div class="vjsGrid"></div>
			<div class="flex-checkbox mb2">
				<span class="control-label">When enabled, the Domain Transfer button will also appear alongside the domain search.</span>
				<label class="switch">
				   <input type="checkbox" class="form-control success wsinput" />
				   <span class="slider round"></span>
				</label>
			</div>			
		</div>
	</div>
</div>
<div class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit TLD</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
                <div class="form-group">
                    <label>Select TLD </label><select type="select" class="form-control tlds">${tldSelect}</select>
                </div>
				<div class="form-group">
					<label>TLD Logo <small>(Optional)</small></label>
					<input type="imagelib" class="form-control tldimage">
				</div>
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);

        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const dsis = this.data && this.data.inputstyle ? this.data.inputstyle : "";
        $(wrapper).find(".dsis").val(dsis);
        const setitle = this.data && this.data.sectitle ? this.data.sectitle : "";
        $(wrapper).find(".setitle").val(setitle);
        const vvimage = this.data && this.data.image ? this.data.image : "";
        $(wrapper).find(".bgsbgcolor").val(vvimage);
        if (this.data.transfer === true) {
            $(wrapper).find('.wsinput').attr('checked', 'checked');
        }
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }

		//
        if ($(wrapper).find('.blockbgcolor').val() == 'imgbg') {
			$(wrapper).find('.simginput').removeClass('hidden');
        } else {
            $(wrapper).find('.simginput').addClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() == 'imgbg') {
                $(wrapper).find('.simginput').removeClass('hidden');
            } else {
                $(wrapper).find('.simginput').addClass('hidden');
            }
        });
		//

		//
        if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == '') {
			$(wrapper).find('.sborderinput').removeClass('hidden');
        } else {
            $(wrapper).find('.sborderinput').addClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == '') {
                $(wrapper).find('.sborderinput').removeClass('hidden');
            } else {
                $(wrapper).find('.sborderinput').addClass('hidden');
            }
        });
		//		
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the TLD <b> \"" + args.item.tld + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {name: "tld", title: "TLDs", type: "select", width: 400, items: bycdomains, valueField: "extension", textField: "extension", align: "left", css: "grid-info-block"},
                {name: "tld image", type: "text", width: 300, visible: false, sorting: false},
                //{type: "control"}
                //changed input to buttons
                {type: "control", editButton: false, width: 50,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                                .addClass(cls)
                                .attr({
                                    type: "button",
                                    title: tooltip
                                })
                                .on("click", function (e) {
                                    //clickHandler(grid, e);
									showDetailsDialog("Add", {});
                                });
                    },

                    editValue: function () {
                        return "";
                    }


                } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, product, itemIndex) {
			
			
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "tld_new_" : "tld_" + itemIndex;

			$(wrapper).find('input[type="imagelib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageGraphics(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageGraphics('" + uniqueId + "')");
				}
			});
			
            $(wrapper).find(".tlds").val(product.tld);
            $(wrapper).find(".tldimage").val(product['tld image']);
			$(wrapper).find(".tlds").select2().trigger("change");
		
            formSubmitHandler = function () {
                saveProduct(product, dialogType === "Add");
            };

            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .tlds").prop("selectedIndex") === -1) {
			  alert('Please select a tld from the list.');
			  e.preventDefault();
			} else {
			  formSubmitHandler();
			}
        });

        var saveProduct = function (product, isNew) {
            const updatedProduct = {
                tld: $(wrapper).find(".tlds").val(),
				'tld image': $(wrapper).find(".tldimage").val()
            };

            if (isNew) $(wrapper).find(".vjsGrid").jsGrid("insertItem", updatedProduct);
            else $(wrapper).find(".vjsGrid").jsGrid("updateItem", product, updatedProduct);

            $(wrapper).find(".modal").modal('hide');
        };
		
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
        var status = $(blockContent).find(".wsinput").is(':checked');
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
			"image": $(blockContent).find(".bgsbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "inputstyle": $(blockContent).find(".dsis").val(),
            "sectitle": $(blockContent).find(".setitle").val(),
            "transfer": status,
			"sechidden": sechidden
        };
    }
}