class bgsection {
    static get toolbox() {
        return {
            title: 'Call to Action (Deprecate)',
            icon: '<i class="fas fa-bars"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            code: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
				u: true,
				strike: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            },
            title: {
                 b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Call to Action<span class="sec-docs text-danger" href="#" data-container="body" data-toggle="popover" data-trigger="hover" data-html="true" data-content="This section will be removed in the upcoming release. You will need to migrate the contents into the <strong>Banner</strong> section.">Deprecated</span></label>
            <input type="text" value="" readonly="readonly"/>
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control bgctitle" placeholder="Section Title" value=""/>
				</div>
				<div class="form-group">
					<label>Description</label>
					<textarea class="form-control bgctext" rows="6"></textarea>
				</div>
			</div>
			<div class="heading">
				<h5>Section Button</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Button Text</label>
					<input type="text" class="form-control bgcbtitle" />
				</div>
				<div class="form-group">
					<label>Button Link Type</label>
					<select type="select" class="form-control linktype">
						<option value="">Custom URL</option>
						<option value="1">Page Manager</option>
						<option value="2">Product Group</option>
						<option value="3">Product</option>
					</select>
				</div>
				<div class="curl">
					<div class="form-group">
						<label>Link To</label>
						<input type="text" class="form-control bgclink" placeholder="add custom URL..">
					</div>
				</div>
				<div class="purl">
					<div class="form-group">
						<label>Link To</label>
						<select type="select" class="form-control pagelink">${cmsPages}</select>
					</div>
				</div>
				<div class="gurl">
					<div class="form-group">
						<label>Link To</label>
						<select type="select" class="form-control grouplink">${groupSelect}</select>
					</div>
				</div>
				<div class="pdurl">
					<div class="form-group">
						<label>Link To</label>
						<select type="select" class="form-control productlink">${productsSelect}</select>
					</div>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
				 <label>Background Type</label>
				 <select type="select" class="form-control blockbgcolor">
				   <option value="">Default</option>
				   <option value="bg-primary">Primary</option>
				   <option value="light">Light</option>
				   <option value="dark">Dark</option>
				   <option value="noimg">None</option>
				 </select>
				</div>
				<div class="simginput">
					<div class="form-group">
						<label>Background Image</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-bgsbgcolor" class="form-control bgsbgcolor" value="" />
							<span onclick="PageGraphics('${this.data.id}-bgsbgcolor')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>					
						<span class="help-block">Set a custom background image to replace the default one.</span>
					</div>
				</div>
				<div class="sborderinput">
					<div class="form-group">
					  <label>Border</label>
					  <select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top</option>
						<option value="border-bottom">Bottom</option>
						<option value="border-top-bottom">Both</option>
					  </select>
					</div>
				</div>
			</div>
			<div class="heading collapsed" data-toggle="collapse" href="#${this.data.id}-2">
				<h5>Section Image</h5>
				<button type="button" class="heading_btn">
					<span class="heading_btn_text">Expand</span>
					<span class="heading_btn_text">Hide</span>
					<span class="fal fa-angle-down"></span>
				</button>
			</div>
			<div id="${this.data.id}-2" class="collapse">
				<div class="sec_groups">
					<div class="form-group">
						<label>Image</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-bsecimg" class="form-control bsecimg" value="" />
							<span onclick="PageGraphics('${this.data.id}-bsecimg')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>
					</div>
					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
								<label>Alt Text</label>
								<input type="text" class="form-control bsecimgalt" placeholder="" value=""/>
								<span class="help-block">This will be used as the 'alt' attribute for the image.</span>
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group">
							  <label>Position</label>
							  <select type="select" class="form-control simgp">
								<option value="">Left</option>
								<option value="col-right">Right</option>
							  </select>
							  <span class="help-block">Choose the position where you want the graphic to be displayed.</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>`);
		
        const title = this.data && this.data.title ? this.data.title : "";
        const title_button = this.data && this.data.title_button ? this.data.title_button : "";
        $(wrapper).find(".bgcbtitle").val(title_button);
        const vvimage = this.data && this.data.image ? this.data.image : "";
        $(wrapper).find(".bgsbgcolor").val(vvimage);
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const vvlink = this.data && this.data.link ? this.data.link : "";
        $(wrapper).find(".bgclink").val(vvlink);
		
        const linkType = this.data && this.data.LinkType ? this.data.LinkType : "";
        $(wrapper).find(".linktype").val(linkType);
		
        const PageLink = this.data && this.data.link ? this.data.link : "";
        $(wrapper).find(".pagelink").val(PageLink);
        const GroupLink = this.data && this.data.link ? this.data.link : "";
        $(wrapper).find(".grouplink").val(GroupLink);
        const ProductLink = this.data && this.data.link ? this.data.link : "";
        $(wrapper).find(".productlink").val(ProductLink);		
		
        const code = this.data && this.data.code ? this.data.code : "";
        $(wrapper).find(".bgctext").val(code);
        const bsecimg = this.data && this.data.secimg ? this.data.secimg : "";
        $(wrapper).find(".bsecimg").val(bsecimg);
        const bsecimgalt = this.data && this.data.secimgalt ? this.data.secimgalt : "";
        $(wrapper).find(".bsecimgalt").val(bsecimgalt);
        const simgp = this.data && this.data.secimgp ? this.data.secimgp : "";
        $(wrapper).find(".simgp").val(simgp);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
		
		const select2Elements = [
			{ selector: ".pagelink", placeholder: 'Select a page' },
			{ selector: ".productlink", placeholder: 'Select a product' },
			{ selector: ".grouplink", placeholder: 'Select a products group' }
		];

		select2Elements.forEach(function(item) {
			$(wrapper).find(item.selector).select2({
				placeholder: item.placeholder,
				allowClear: true
			});
		});
		
		//
        if ($(wrapper).find('.blockbgcolor').val() !== '') {
			$(wrapper).find('.simginput').addClass('hidden');
        } else {
            $(wrapper).find('.simginput').removeClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() !== '') {
                $(wrapper).find('.simginput').addClass('hidden');
            } else {
                $(wrapper).find('.simginput').removeClass('hidden');
            }
        });
		//
		
		//
        if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == 'noimg') {
			$(wrapper).find('.sborderinput').removeClass('hidden');
        } else {
            $(wrapper).find('.sborderinput').addClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == 'noimg') {
                $(wrapper).find('.sborderinput').removeClass('hidden');
            } else {
                $(wrapper).find('.sborderinput').addClass('hidden');
            }
        });
		//
		
		//
		function btnLinkVisibility(wrapper, value) {
			$(wrapper).find('.curl, .purl, .gurl, .pdurl').addClass('hidden');
			switch (value) {
				case '':
					$(wrapper).find('.curl').removeClass('hidden');
					break;
				case '1':
					$(wrapper).find('.purl').removeClass('hidden');
					break;
				case '2':
					$(wrapper).find('.gurl').removeClass('hidden');
					break;
				case '3':
					$(wrapper).find('.pdurl').removeClass('hidden');
					break;
			}
		}
		
		btnLinkVisibility(wrapper, $(wrapper).find('.linktype').val());
		$(wrapper).find('.linktype').on('change', function () {
			btnLinkVisibility(wrapper, $(this).val());
		});
		
		
        $(wrapper).find(".bgctext").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });
		//
		
        setTimeout(function () {
            $(wrapper).find(".bgctitle").val(title);
        }, 200);        
        return wrapper;
    }

    save(blockContent) {
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var descriptionContent = $(blockContent).find('.bgctext').trumbowyg('html');
		
		function getLinkBasedOnLinkType(LinkType) {
			switch (LinkType) {
				case "1":
					return $(blockContent).find(".pagelink").val();
				case "2":
					return $(blockContent).find(".grouplink").val();
				case "3":
					return $(blockContent).find(".productlink").val();
				default:
					return $(blockContent).find(".bgclink").val();
			}
		}
		
        return {
			"id": this.data.id,
            "image": $(blockContent).find(".bgsbgcolor").val(),
			"bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "title": $(blockContent).find(".bgctitle").val(),
            "title_button": $(blockContent).find(".bgcbtitle").val(),
			"secimg": $(blockContent).find(".bsecimg").val(),
			"secimgalt": $(blockContent).find(".bsecimgalt").val(),
			"secimgp": $(blockContent).find(".simgp").val(),
			"LinkType": $(blockContent).find(".linktype").val(),
            "link": getLinkBasedOnLinkType($(blockContent).find(".linktype").val()),
			"sechidden": sechidden,
            "code": descriptionContent
        };
    }
}