class LastAnnouncements {
    static get toolbox() {
        return {
            title: 'Announcements',
            icon: '<i class="fas fa-bullhorn"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            title: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Announcements<a class="sec-docs" href="https://docs.thememetro.com/#Sec-Announcements" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control laname" value="" />
				</div>
				<div class="form-group">
					<label>list count</label>
					<input type="text" class="form-control laitems" value="" />
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
					   <option value="">None</option>
					   <option value="light">Light</option>
					</select>
				</div> 
				<div class="form-group">
					<label>Background Image</label>
					<div class="input-group">
						<input type="text" id="${this.data.id}-bgsbgcolor" class="form-control bgsbgcolor" value="" />
						<span onclick="PageGraphics('${this.data.id}-bgsbgcolor')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
					</div>
				</div>
				<div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					 </select>
				</div>
			</div>
		</div>
	</div>
</div>`);
		
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);	
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);	
        const title = this.data && this.data.title ? this.data.title : "";     
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "3";
        $(wrapper).find(".laitems").val(laitems);
        const vvimage = this.data && this.data.image ? this.data.image : "";
        $(wrapper).find(".bgsbgcolor").val(vvimage);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }

		$(wrapper).find(".laitems").on('input', function() {
			const value = $(this).val();
			const min = 1;
			const max = 4;
			if (/^\d+$/.test(value)) {
				const numberValue = parseInt(value, 10);
				
				if (numberValue < min || numberValue > max) {
					swal({
						title: "",
						text: `Please enter a number between ${min} and ${max}.`,
						type: "warning",
						confirmButtonColor: "#c1c1c1",
						buttons: true,
						dangerMode: true,
					});
					$(this).val('3');
				}
			} else {
				swal({
					title: "",
					text: "Please enter a valid number.",
					type: "warning",
					confirmButtonColor: "#c1c1c1",
					buttons: true,
					dangerMode: true,
				});
				$(this).val('3'); 
			}
		});
		
        setTimeout(function () {
            $(wrapper).find(".laname").val(title);
        }, 200);        
        return wrapper;
    }

    save(blockContent) {
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
        return {
			"id": this.data.id,
            "itemcounts": $(blockContent).find(".laitems").val(),
            "title": $(blockContent).find(".laname").val(),
            "image": $(blockContent).find(".bgsbgcolor").val(),
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
			"sechidden": sechidden            
        };
    }
}

