# 20i Modules for WHMCS

## Introduction

These are modules to provide access to 20i from WHMCS.
For help with installation, please see https://www.20i.com/support/reseller-hosting/integrating-whmcs

## System Requirements

+ PHP 5.6 or later
+ WHMCS 7.1 or later

## Manual Installation

Run the following commands, replacing `<your whmcs directory>` with the path to
your WHMCS directory, something like `/var/www/whmcs`. Please note that you
should be careful when copying and pasting to exclude spaces as that changes the
meaning of these commands.

If you already have the module installed, you will need to move the include
directory out of the way:

```
mv <your whmcs directory>/20i <your whmcs directory>/20i~
```

Then you can copy the new files over:

```
cp -r 20i <your whmcs directory>/
cp -rf modules <your whmcs directory>/
```

If you moved the old include directory out of the way, you should now remove it:

```
rm -rI <your whmcs directory>/20i~
```

## Manual Installation (Cleanup)

If you have accidentally copied other files into your WHMCS directory, you
should remove them. You can do this by running:

```
rm <your whmcs directory>/{LICENSE,README.md}
```

## Configuration

These instructions are subject to change as the WHMCS user interface is updated. Please refer to your WHMCS documentation if you can't find something mentioned here.

### Initial Configuration

1. Set up a field to store stack user details. This should be in `Setup`->`Custom Client Fields`. You can pick a name, select 'text box' and enable 'Admin only'.

### Hosting Package Configuration

2. Add a server bound to the 20i provisioning module, this should be `Setup`->`Products/Services`->`Servers`. Put your combined API key in the password field. If you don't have a combined API key yet, you can get it from https://my.20i.com/reseller/api. Leave the username blank.

3. Add some hosting products. This is in `Setup`->`Products/Services`->`Products/Services`. On the new product(s), you'll need to go to `Module Settings`, select the 20i module, and fill in the configuration there. You also need to go into `Custom Fields` and add a field "packageId" which is admin-only.

### Domain Configuration

4. Activate the domain module. This is in `Setup`->`Products/Services`->`Domain Registrars`. Put your combined API key in the password field, and fill in the other fields as you would for hosting products.

5. (Optional) Use 20i for domain lookup. This is in `Setup`->`Products/Services`->`Domain Pricing`. If you click "Change" in "Lookup Provider", you can select the 20i service.

### VPS/MVPS Configuration

6. Add some VPS products. This is in `Setup`->`Products/Services`->`Products/Services`. When doing this, you'll need to ensure that the product type has been set as "Other" as opposed to "Shared Hosting", "Reseller Hosting", or "Server/VPS". You will need to go into `Custom Fields` and add a field named "vpsId" which is admin-only.

In order to configure that which can be sold with the VPS (I.E. operating system, spec, application(s)), you will need to go to System Settings -> Configurable Options.

After heading to Configurable Options, you will then need to select "Create a New Group". Here, you'll want to give the Group Name a sensible name, something like "VPS" or "20i VPS" will suffice. On the same page, you should also be able to see an "Assigned Products" section. Here, select the VPS product you created/added above. Once you've done so, select "Save Changes". Once the change has been saved, select "Back to Groups List". On the right-hand side, select the pencil icon. After doing so, configurable options can now be added using the "Add New Configurable Option" button. Currently, three types of configurable option can be added. The "Operating System" a VPS can be provisioned with, the "Application" a VPS can be provisioned with, and the "Specification" of the VPS. The "Option Name" *must* match "Application", "Operating System", or "Specification" exactly.

Once the Option Name has been set, you can then add options, and their associated prices. E.G. you can have a configurable option/Option Name of "Operating System", and associated options of "CentOS 7", "Debian 10", etc. As with the Option Name, the options mentioned below must be entered exactly as they are into your WHMCS install.

At the time of writing, the following operating systems are available:
CentOS 7
Windows Server 2012 R2
Windows Server 2016
Debian 10
Ubuntu 20.10
Fedora 32
Ubuntu 20.04
Fedora 31
Ubuntu 18.04
FreeBSD 12.1
OpenBSD 6.7
OpenBSD 6.8
Fedora 33
Ubuntu 21.04
Fedora 34
Debian 11
AlmaLinux 8.4
Rocky Linux 8.4
Oracle Linux 8.4

As are the following applications:
CMS Made Simple
Concrete5
CraftCMS
Drupal
Elgg
FengOffice
Joomla!
Magento
MediaWiki
Moodle
OpenCart
OSTicket
PrestaShop
SimpleInvoices
StatusNET
TomatoCart
WordPress
ZenCart

And finally, the specifications that can be assigned:
1CPU Cores, 25GB SSD, 1GB RAM
2CPU Cores, 50GB SSD, 2GB RAM
4CPU Cores, 75GB SSD, 4GB RAM
6CPU Cores, 150GB SSD, 8GB RAM
8CPU Cores, 200GB SSD, 16GB RAM
10CPU Cores, 400GB SSD, 32GB RAM
Managed 1CPU Cores, 25GB SSD, 1GB RAM
Managed 2CPU Cores, 50GB SSD, 2GB RAM
Managed 4CPU Cores, 75GB SSD, 4GB RAM
Managed 6CPU Cores, 100GB SSD, 8GB RAM
Managed 8CPU Cores, 200GB SSD, 16GB RAM
Managed 10CPU Cores, 400GB SSD, 32GB RAM

### Data Centre Location Configuration (Shared Hosting & VPS)
At 20i, additional data centre locations can be purchased via:
https://my.20i.com/services/order-dclocation

An additional DC location permits hosting packages and virtual machines to be provisioned in that particular part of the world, for example in the UK, or the USA.

If an additional location has been purchased, in order to allow WHMCS to provision products accordingly, a configurable option must be configured within WHMCS.

1. Login to WHMCS.
2. Head to Configuration -> System Settings
3. Within System Settings, select Configurable Options
4. Select "Create a New Group"
5. Give the group a name; we advise using "DC Location", and a description. Once you've done so, select "Save Changes".
6. Once the new group has been saved, manage the group, and select "Add New Configu
rable Option".
7. In the window that appears, ensure that the Option Name is set to be "Data Centre Location". The Option Name must match this string exactly (including capitalisation).
8. In the same window, add both "UK" and "USA" as options, and configure pricing fo
r them accordingly.
9. Once happy, select "Save Changes'.

If the DC location you wish to provision to has not yet been purchased within your 20i account, any orders or products attempting to provision using that location will fail to do so.

If a configurable option is not configured, a hosting package/VPS will provision using the default data centre location assigned to the 20i account.

Switching a package/VPS from one data centre location to another is not currently supported.

### Retrieving Usage Statistics
The 20i WHMCS module supports the retrieval of usage statistics. So long as the default WHMCS cron has been configured (via Scheduled Tasks within the 20i hosting control panel) the module will update the Shared Hosting products within the install with the current disk and bandwidth usage, as well as the disk and bandwidth limits. This can be useful if for example you currently charge customers within WHMCS with respect to usage.

## Products

### .uk Domains

Since WHMCS does not support 0-year transfers, for TLDs which have this
behaviour, like *.uk*, you must set a price of 0.00 for 1-year transfers and
disable (-1) all other transfer year options. Any 1-year transfer orders for a
price of 0.00 will be automatically corrected to 0-year.

### Domain Privacy (ID protection)

For .UK domains this will do nothing by default, in case you already have a product set up for the free individuals-only "WHOIS opt-out" service. Once you have a chargeable product set up for this, you can enable it by ticking `Enable paid privacy service for .UK` in `Setup`->`Products/Services`->`Domain Registrars`.

## Advanced Topics

### Importing Services

Under some circumstances you may want to set up a service as if it had been
purchased via 20i on your WHMCS install. This may include cases where you've
migrated services from another WHMCS provider.

### Hosting packages

Manual method:

1. Log in to my.20i.com
2. Go to Manage Hosting
3. Click Options->Edit on the package you're looking for
4. Copy the ID number from the header
5. Go to the Product/Service in WHMCS Admin
6. Paste the ID number into the "packageId" field near the bottom

Autodetect method:

1. Go to the Product/Service in WHMCS Admin
2. In the "packageId" field near the bottom, type an asterisk "*"

Autodetect only works when you have a package with a name which exactly matches
the domain name in WHMCS. The behaviour is undefined if you delete and recreate
a package, or move a domain name between packages.

### VPS/MVPS

Manual method:

Currently, we do not expose VPS IDs via the control panel. If you require the manual configuration of VPSs, please contact Support who will be able to provide the ID for the VPS. Once the VPS ID has been obtained, enact the following:

1. Login to WHMCS admin
2. Go to the relevant VPS product in WHMCS admin
3. Paste the VPS ID into the "vpsId" field near the bottom of the page

### Importing Stack Users

If you've set up Stack users, you may want to copy them over so that your
customer can access all their services from within Stack without having to go
back to your WHMCS site. This is only applicable to existing unlinked Stack
users, as new Stack users are set up automatically whenever a new order is
placed in WHMCS.

Please note that imported users will not have their access changed, so you may
also want to review which services they have access to.

Manual method:

1. Log in to my.20i.com
2. Go to StackCP Users
3. Click Options->Edit on the user you're looking for
4. Copy the user reference from the header (something like "stack-user:42")
5. Go to the appropriate Client in WHMCS admin
6. Select Profile
7. Paste the user reference into your Stack user field near the bottom

Autodetect method:

1. Go to the appropriate Client in WHMCS admin
2. Select Profile
3. In your Stack user field (towards the bottom of the page), type an asterisk "*"

If you use autodetect, you should be aware that this may connect a Stack user
which you didn't intend to allow access to. Autodetect only works when the WHMCS
user email address exactly matches one of your stack user email addresses.
