{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $themesettings.clientarea.loginpagestyle eq ""}
<div id="wrapper" class="primary-content" style="min-height: auto; margin: auto;">
	<div class="container">
		<div class="login-container">	
			<div class="login-header">
				<a href="{if $themesettings.headersetting.CustomLogoLink}{$themesettings.headersetting.CustomLogoLink}{else}{$WEB_ROOT}/{/if}">
					{if $themesettings.general.enablelogo}
						<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
						{if $themesettings.general.darklogo}
						<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
						{else}
						<span class="logo-dark">{$companyname}</span>
						{/if}
					{else}
						<span class="logo-dark">{$companyname}</span>
						<span class="logo-light">{$companyname}</span>
					{/if}
				</a>		
			</div>
			<div class="login-box">				
				<h1 class="h6 text-uppercase">
					<i class="fas fa-key"></i> <b>{lang key='twofactorauth'}</b>
				</h1>		
				<hr />			
				<div class="logincontainer" style="margin: 0; padding: 0;">
					{include file="$template/includes/flashmessage.tpl" align="center"}
					{if $newbackupcode}
						{include file="$template/includes/alert.tpl" type="success" msg="{lang key='twofabackupcodereset'}" textcenter=true}
					{elseif $incorrect}
						{include file="$template/includes/alert.tpl" type="error" msg="{lang key='twofa2ndfactorincorrect'}" textcenter=true}
					{elseif $error}
						{include file="$template/includes/alert.tpl" type="error" msg=$error textcenter=true}
					{else}
						{include file="$template/includes/alert.tpl" type="warning" msg="{lang key='twofa2ndfactorreq'}" textcenter=true}
					{/if}
					<form method="post" action="{routePath('login-two-factor-challenge-verify')}" id="frmTwoFactorChallenge"{if $usingBackup} class="w-hidden"{/if}>
						<div class="margin-bottom">
							{$challenge}
						</div>
					</form>
					<form method="post" action="{routePath('login-two-factor-challenge-backup-verify')}" id="frmTwoFactorBackup"{if !$usingBackup} class="w-hidden"{/if}>
						<div class="margin-bottom">
							<input type="text" name="twofabackupcode" class="form-control form-control-lg" placeholder="{lang key='twofabackupcodelogin'}">
							<br/>
							<button type="submit" class="btn btn-primary btn-lg btn-block" id="btnLogin">
								{lang key='loginbutton'}
							</button>
						</div>
						<p class="text-center">
							<a href="#" class="btn btn-default btn-block mt-2" id="backupCodeCancel">
								{lang key='cancel'}
							</a>
						</p>
					</form>
					<div class="p-3" id="frmTwoFactorChallengeFooter">
						<small>
							{lang key='twofacantaccess2ndfactor'}
							<a href="#" id="loginWithBackupCode">
								{lang key='twofaloginusingbackupcode'}
							</a>
						</small>
					</div>
				</div>

			</div>
			
			{if $languagechangeenabled && count($locales) > 1}
				<div class="lang-btn d-flex align-items-center justify-content-center">
					<button type="button" class="btn" data-toggle="modal" data-target="#modalChooseLanguage">
						<div class="d-inline-block align-middle">
							<div class="iti-flag {if $activeLocale.countryCode === '001'}us{else}{$activeLocale.countryCode|lower}{/if}"></div>
						</div>
						{$activeLocale.localisedName}
					</button>
				</div>
			{/if}	
		</div>
	</div>
</div>

{else}

<div class="primary-content loginpage-with-sidebar sidebar-left">
    <div class="sidebar-container light">
        <div class="login-header">
			<a href="{if $themesettings.headersetting.CustomLogoLink}{$themesettings.headersetting.CustomLogoLink}{else}{$WEB_ROOT}/{/if}">
				{if $themesettings.general.enablelogo}
					<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
					{if $themesettings.general.darklogo}
					<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
					{else}
					<span class="logo-dark">{$companyname}</span>
					{/if}
				{else}
					<span class="logo-dark">{$companyname}</span>
					<span class="logo-light">{$companyname}</span>
				{/if}
			</a>
        </div>
        <div class="sidebar-content">
			{if $announcements}
				<h2 class="header fw-400">{$LANG.ourlatestnews}</h2>
				<div id="annuncements" class="swiper-container">
					<div class="swiper-wrapper">
					{foreach $announcements as $announcement}
						{if $announcement@index < 3}
							<div class="swiper-slide">
								<span class="text-muted">
									<i class="fad fa-calendar-week"></i>&nbsp;{"jS M Y"|date:$announcement.timestamp}
								</span>
								<a href="{routePath('announcement-view', $announcement.id, $announcement.urlfriendlytitle)}"><h2 class="h3 bolder">{$announcement.title}</h2></a>
								<p>{$announcement.text|strip_tags|truncate:160:"..."}</p>
							</div>
						{/if}
					{/foreach}
					</div>
					<div class="swiper-pagination"></div>
				</div>
			{/if}
			<div class="user_lock_icon">
				<i class="fad fa-user-lock"></i>
			</div>
		</div>
    </div>        
    <div class="center-container">
		<div class="login-container">	
			<div class="login-header">
				<a href="{if $themesettings.headersetting.CustomLogoLink}{$themesettings.headersetting.CustomLogoLink}{else}{$WEB_ROOT}/{/if}">
					{if $themesettings.general.enablelogo}
						<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
						{if $themesettings.general.darklogo}
						<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
						{else}
						<span class="logo-dark">{$companyname}</span>
						{/if}
					{else}
						<span class="logo-dark">{$companyname}</span>
						<span class="logo-light">{$companyname}</span>
					{/if}
				</a>		
			</div>
			<div class="login-box">				
				<h1 class="h6 text-uppercase">
					<i class="fas fa-key"></i> <b>{lang key='twofactorauth'}</b>
				</h1>		
				<hr />			
				<div class="logincontainer" style="margin: 0; padding: 0;">
					{include file="$template/includes/flashmessage.tpl" align="center"}
					{if $newbackupcode}
						{include file="$template/includes/alert.tpl" type="success" msg="{lang key='twofabackupcodereset'}" textcenter=true}
					{elseif $incorrect}
						{include file="$template/includes/alert.tpl" type="error" msg="{lang key='twofa2ndfactorincorrect'}" textcenter=true}
					{elseif $error}
						{include file="$template/includes/alert.tpl" type="error" msg=$error textcenter=true}
					{else}
						{include file="$template/includes/alert.tpl" type="warning" msg="{lang key='twofa2ndfactorreq'}" textcenter=true}
					{/if}
					<form method="post" action="{routePath('login-two-factor-challenge-verify')}" id="frmTwoFactorChallenge"{if $usingBackup} class="w-hidden"{/if}>
						<div class="margin-bottom">
							{$challenge}
						</div>
					</form>
					<form method="post" action="{routePath('login-two-factor-challenge-backup-verify')}" id="frmTwoFactorBackup"{if !$usingBackup} class="w-hidden"{/if}>
						<div class="margin-bottom">
							<input type="text" name="twofabackupcode" class="form-control form-control-lg" placeholder="{lang key='twofabackupcodelogin'}">
							<br/>
							<button type="submit" class="btn btn-primary btn-lg btn-block" id="btnLogin">
								{lang key='loginbutton'}
							</button>
						</div>
						<p class="text-center">
							<a href="#" class="btn btn-default btn-block mt-2" id="backupCodeCancel">
								{lang key='cancel'}
							</a>
						</p>
					</form>
					<div class="p-3" id="frmTwoFactorChallengeFooter">
						<small>
							{lang key='twofacantaccess2ndfactor'}
							<a href="#" id="loginWithBackupCode">
								{lang key='twofaloginusingbackupcode'}
							</a>
						</small>
					</div>
				</div>

			</div>
			
			{if $languagechangeenabled && count($locales) > 1}
				<div class="lang-btn d-flex align-items-center justify-content-center">
					<button type="button" class="btn" data-toggle="modal" data-target="#modalChooseLanguage">
						<div class="d-inline-block align-middle">
							<div class="iti-flag {if $activeLocale.countryCode === '001'}us{else}{$activeLocale.countryCode|lower}{/if}"></div>
						</div>
						{$activeLocale.localisedName}
					</button>
				</div>
			{/if}	
		</div>
    </div>
</div>

<script>
	jQuery(document).ready(function () {
		var swiper = new Swiper('#annuncements', {
		  slidesPerView: 1,
		  pagination: {
			el: '.swiper-pagination',
			clickable: true,
		  },

		  breakpoints: {
			0: {
				slidesPerView: 1,
			},
		  }
		  
		});
	});
</script>
{/if}

<script src="{$WEB_ROOT}/templates/{$template}/assets/js/main.min.js?v={$versionHash}"></script>

<script>
    jQuery(document).ready(function() {
        jQuery('#loginWithBackupCode').click(function(e) {
            e.preventDefault();
            jQuery('#frmTwoFactorChallenge').hide();
            jQuery('#frmTwoFactorChallengeFooter').hide();
            jQuery('#frmTwoFactorBackup').show();
        });
        jQuery('#backupCodeCancel').click(function(e) {
            e.preventDefault();
            jQuery('#frmTwoFactorChallenge').show();
            jQuery('#frmTwoFactorChallengeFooter').show();
            jQuery('#frmTwoFactorBackup').hide();
        });
    });
</script>
