<div class="landing-page sitelock">

    <div class="hero">
        <div class="container">
            <img class="img-fluid" src="{$WEB_ROOT}/assets/img/marketconnect/sitelock/logo.png">
            <h3 class="h4">{lang key="store.sitelock.tagline"}</h3>
        </div>
    </div>

    <nav class="navbar navbar-light navbar-expand-lg border-top border-bottom">
      <div class="container">
        <span class="navbar-brand"></span>
        <button type="button" class="navbar-toggler collapsed" data-toggle="collapse" data-target="#nav-landing-page" aria-expanded="false">
          <span class="sr-only">{lang key="toggleNav"}</span>
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="nav-landing-page">
          <ul class="nav navbar-nav">
            <li class="nav-item"><a class="nav-link" href="#" onclick="smoothScroll('#plans');return false">{lang key="store.sitelock.plansAndPricing"}</a></li>
            <li class="nav-item"><a class="nav-link" href="#" onclick="smoothScroll('#features');return false">{lang key="store.sitelock.featuresLink"}</a></li>
            <li class="nav-item"><a class="nav-link" href="#" onclick="smoothScroll('#emergency');return false">{lang key="store.sitelock.websiteHacked"}</a></li>
            <li class="nav-item"><a class="nav-link" href="#" onclick="smoothScroll('#faq');return false">{lang key="store.sitelock.faq"}</a></li>
          </ul>
        </div>
      </div>
    </nav>

    <div class="content-block">
        <div class="container">
			<h3>{lang key="store.sitelock.contentHeadline"}</h3>
			<p>{lang key="store.sitelock.contentBodyParagraph1"}</p>
			<p>{lang key="store.sitelock.contentBodyParagraph2"}</p>
			<p>{lang key="store.sitelock.contentBodyParagraph3"}</p>
        </div>
    </div>

    <div class="content-block plans" id="plans">
        <div class="container">

            {if !$loggedin && $currencies}
                <form method="post" action="" class="pull-right">
                    <select name="currency" class="form-control currency-selector" onchange="submit()">
                        <option>{lang key="changeCurrency"} ({$activeCurrency.prefix} {$activeCurrency.code})</option>
                        {foreach $currencies as $currency}
                            <option value="{$currency['id']}">{$currency['prefix']} {$currency['code']}</option>
                        {/foreach}
                    </select>
                </form>
            {/if}
			
			<div class="text-center">
				<h2>{lang key="store.sitelock.comparePlans"}</h2>
				<h4>{lang key="store.sitelock.comparePlansSubtitle"}</h4>
			</div>

            <div class="row plan-comparison">
                {foreach $plans as $plan}
                    <div class="col-lg-{if count($plans) == 4}3{elseif count($plans) == 3}4{elseif count($plans) == 2}4 {if $plan@first}offset-lg-2{/if}{else}4 offset-lg-4{/if} {if count($plans) == 1}offset-md-3{/if}">
                        <div class="plan">
                            <div class="header">
                                <h4>
                                    {$plan->name}
                                    <span class="float-right">
                                        {if $plan->isFree()}
                                            {lang key="orderpaymenttermfree"}
                                        {elseif $plan->pricing()->annually()}
                                            {$plan->pricing()->annually()->toPrefixedString()}
                                        {elseif $plan->pricing()->first()}
                                            {$plan->pricing()->first()->toPrefixedString()}
                                        {else}
                                            -
                                        {/if}
                                    </span>
                                </h4>
                                <p>{$plan->description}</p>
                            </div>
                            <ul>
                                {foreach $plan->features as $label => $value}
                                    <li>
                                        <span>{$label}</span>

                                        {if is_bool($value)}
                                            <i class="fas fa-{if $value}check{else}times{/if}"></i>
                                        {else}
                                            {$value}
                                        {/if}
                                    </li>
                                {/foreach}
                            </ul>
                            <div class="footer">
                                <form method="post" action="{routePath('cart-order')}">
                                    <input type="hidden" name="pid" value="{$plan->id}">
                                    <select name="billingcycle" class="form-control">
                                        {foreach $plan->pricing()->allAvailableCycles() as $cycle}
                                            <option value="{$cycle->cycle()}">
                                                {if $cycle->isRecurring()}
                                                    {if $cycle->isYearly()}
                                                        {$cycle->cycleInYears()}
                                                    {else}
                                                        {$cycle->cycleInMonths()}
                                                    {/if}
                                                    -
                                                {/if}
                                                {$cycle->toFullString()}</option>
                                        {/foreach}
                                    </select>
                                    <button type="submit" class="btn btn-primary btn-block">{lang key="store.sitelock.buyNow"}</button>
                                </form>
                            </div>
                        </div>
                    </div>
                {/foreach}
            </div>

        </div>
    </div>

    <div class="content-block features" id="features">
        <div class="container">

            <h2>SiteLock Features</h2>
            <h4>Provides a range of features designed to protect both your website and your business’ reputation:</h4>

            <br>

            <div class="row">
                <div class="col-lg-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-search fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.featuresMalwareTitle"}</h4>
                            <p>{lang key="store.sitelock.featuresMalwareContent"}</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-wrench fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.featuresMalwareRemovalTitle"}</h4>
                            <p>{lang key="store.sitelock.featuresMalwareRemovalContent"}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-code fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.featuresVulnerabilityTitle"}</h4>
                            <p>{lang key="store.sitelock.featuresVulnerabilityContent"}</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="feature-wrapper">
                        <i class="far fa-file-code fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.featuresOWASPTitle"}</h4>
                            <p>{lang key="store.sitelock.featuresOWASPContent"}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-trophy fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.featuresTrustSealTitle"}</h4>
                            <p>{lang key="store.sitelock.featuresTrustSealContent"}</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-shield-alt fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.featuresFirewallTitle"}</h4>
                            <p>{lang key="store.sitelock.featuresFirewallContent"}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-lock fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.featuresReputationTitle"}</h4>
                            <p>{lang key="store.sitelock.featuresReputationContent"}</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-star fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.featuresSetupTitle"}</h4>
                            <p>{lang key="store.sitelock.featuresSetupContent"}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-globe fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.featuresCDNTitle"}</h4>
                            <p>{lang key="store.sitelock.featuresCDNContent"}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {if !is_null($emergencyPlan)}
    <div class="content-block emergency" id="emergency">
        <div class="container">

            <h2 class="text-danger">{lang key="store.sitelock.emergencyPlanTitle"}</h2>
            <h3>{lang key="store.sitelock.emergencyPlanHeadline"}</h3>

            <p>{lang key="store.sitelock.emergencyPlanBody"}</p>

            <br>

            <div class="row">
                <div class="col-md-6">
                    <div class="feature-wrapper">
                        <i class="far fa-clock fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.emergencyPlanResponseTitle"}</h4>
                            <p>{lang key="store.sitelock.emergencyPlanResponseContent"}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-times fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.emergencyPlanMalwareTitle"}</h4>
                            <p>{lang key="store.sitelock.emergencyPlanMalwareContent"}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-exclamation-circle fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.emergencyPlanPriorityTitle"}</h4>
                            <p>{lang key="store.sitelock.emergencyPlanPriorityContent"}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="feature-wrapper">
                        <i class="far fa-calendar-check fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.emergencyPlanAftercareTitle"}</h4>
                            <p>{lang key="store.sitelock.emergencyPlanAftercareContent"}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="feature-wrapper">
                        <i class="far fa-envelope fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.emergencyPlanUpdatesTitle"}</h4>
                            <p>{lang key="store.sitelock.emergencyPlanUpdatesContent"}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="feature-wrapper">
                        <i class="fas fa-star fa-fw"></i>
                        <div class="content">
                            <h4>{lang key="store.sitelock.emergencyPlanPaymentTitle"}</h4>
                            <p>{lang key="store.sitelock.emergencyPlanPaymentContent"}</p>
                        </div>
                    </div>
                </div>
            </div>

            <br>

            
			<div class="emergency-buy-banner">
                <div class="emergency-message">
                    {lang key="store.sitelock.emergencyPlanOnlyCost" price="{if $emergencyPlan->pricing()->best()}{$emergencyPlan->pricing()->best()->toFullString()}{else}-{/if}" }
                </div>
                <form method="post" action="{routePath('cart-order')}">
                    <input type="hidden" name="pid" value="{$emergencyPlan->id}">
                    <button type="submit" class="btn btn-danger btn-lg btn-block">
                        {lang key="store.sitelock.buyNow"}
                    </button>
                </form>
			</div>

        </div>
    </div>
    {/if}

    <div class="content-block faq" id="faq">
        <div class="container">
			<div class="mw-928 mx-auto">
				<h2 class="block-title text-center">{lang key="store.sitelock.faqTitle"}</h2>
				
				<div class="panel-group" id="accordion">
					<div class="panel panel-default">
						<div class="panel-heading" id="faqOne" role="tab" aria-controls="collapseOne" aria-expanded="true" data-toggle="collapse" data-target="#collapseOne">
							<h4 class="panel-title">{lang key="store.sitelock.faqOneTitle"}</h4>
						</div>
						<div aria-labelledby="faqOne" class="panel-collapse collapse" id="collapseOne" data-parent="#accordion" role="tabpanel">
							<div class="panel-body">
								{lang key="store.sitelock.faqOneBody"}<br/><br/>
								{lang key="store.sitelock.faqOneBodyLearnMore" learnMoreLink={$learnMoreLink}}
							</div>
						</div>
					</div>
					<div class="panel panel-default">
						<div class="panel-heading" id="faqTwo" role="tab" aria-controls="collapseTwo" aria-expanded="false" class="collapsed" data-toggle="collapse" data-target="#collapseTwo">
							<h4 class="panel-title">{lang key="store.sitelock.faqTwoTitle"}</h4>
						</div>
						<div aria-labelledby="faqTwo" class="panel-collapse collapse" id="collapseTwo" data-parent="#accordion" role="tabpanel">
							<div class="panel-body">
								{lang key="store.sitelock.faqTwoBody"}
							</div>
						</div>
					</div>
					<div class="panel panel-default">
						<div class="panel-heading" id="faqThree" role="tab" aria-controls="collapseThree" aria-expanded="false" class="collapsed" data-toggle="collapse" data-target="#collapseThree">
							<h4 class="panel-title">{lang key="store.sitelock.faqThreeTitle"}</h4>
						</div>
						<div aria-labelledby="faqThree" class="panel-collapse collapse in" id="collapseThree" data-parent="#accordion" role="tabpanel">
							<div class="panel-body">
								{lang key="store.sitelock.faqThreeBody"}<br/>
								<ul>
									<li>{lang key="store.sitelock.faqThreeBodyList1"}</li>
									<li>{lang key="store.sitelock.faqThreeBodyList2"}</li>
									<li>{lang key="store.sitelock.faqThreeBodyList3"}</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="panel panel-default">
						<div class="panel-heading" id="faqFour" role="tab" aria-controls="collapseFour" aria-expanded="false" class="collapsed" data-toggle="collapse" data-target="#collapseFour">
							<h4 class="panel-title">{lang key="store.sitelock.faqFourTitle"}</h4>
						</div>
						<div aria-labelledby="faqFour" class="panel-collapse collapse" id="collapseFour" data-parent="#accordion" role="tabpanel">
							<div class="panel-body">
								{lang key="store.sitelock.faqFourBodyParagraph1" vulnerabilityStrong="<strong>{lang key="store.sitelock.websiteVulnerability"}</strong>"}<br/><br/>
								{lang key="store.sitelock.faqFourBodyParagraph2" malwareStrong="<strong>{lang key="store.sitelock.malware"}</strong>"}<br/><br/>
							</div>
						</div>
					</div>
					<div class="panel panel-default">
						<div class="panel-heading" id="faqFive" role="tab" aria-controls="collapseFive" aria-expanded="false" class="collapsed" data-toggle="collapse" data-target="#collapseFive">
							<h4 class="panel-title">{lang key="store.sitelock.faqFiveTitle"}</h4>
						</div>
						<div aria-labelledby="faqFive" class="panel-collapse collapse" id="collapseFive" data-parent="#accordion" role="tabpanel">
							<div class="panel-body">
								{lang key="store.sitelock.faqFiveBody"}
							</div>
						</div>
					</div>
					<div class="panel panel-default">
						<div class="panel-heading" id="faqSix" role="tab" aria-controls="collapseSix" aria-expanded="false" class="collapsed" data-toggle="collapse" data-target="#collapseSix">
							<h4 class="panel-title">{lang key="store.sitelock.faqSixTitle"}</h4>
						</div>
						<div aria-labelledby="faqSix" class="panel-collapse collapse" id="collapseSix" data-parent="#accordion" role="tabpanel">
							<div class="panel-body">
								{lang key="store.sitelock.faqSixBody"}
							</div>
						</div>
					</div>
				</div>
			</div>
        </div>
    </div>

    <div class="content-block">
        <div class="container text-center">
            <img class="img-fluid" src="{$WEB_ROOT}/assets/img/marketconnect/sitelock/logo.png">
        </div>
    </div>

</div>
