{if count($existingCards) > 0}
	<div class="cc-input-container">
		<div class="existing-cc-grid">
			<div class="card-list">
				{foreach $existingCards as $cardInfo}
					{assign "payMethodExpired" 0}
					{assign "expiryDate" ""}
					{assign "payMethod" $cardInfo.payMethod nocache}
					{if $payMethod->payment->isExpired()}
						{assign "payMethodExpired" 1}
					{/if}
					{if $payMethod->payment->getExpiryDate()}
						{assign "expiryDate" $payMethod->payment->getExpiryDate()->format('m/Y')}
					{/if}
					
					<label class="card-item border rounded{if ($cardOnFile && $payMethodExpired) || !$cardOnFile} disabled{/if}{if $payMethod->isDefaultPayMethod()} selected{/if}" data-paymethod-id="{$cardInfo.paymethodid}" {if !$hasRemoteInput}onclick="hideNewCardInputFields();"{/if} for="existing-card">
						<div class="card-item-checkbox ml-0" data-paymethod-id="{$cardInfo.paymethodid}">
							<input
									id="existingCard{$cardInfo.paymethodid}"
									type="radio"
									name="ccinfo"
									class="existing-card icheck-button"
									data-billing-contact-id="{$cardInfo.billingcontactid}"
									{if $cardOnFile && !$payMethodExpired && $payMethodId eq $cardInfo.paymethodid}
										{assign "preselectedBillingContactId" {$cardInfo.billingcontactid}}
										checked="checked" data-loaded-paymethod="true"
									{elseif ($cardOnFile && $payMethodExpired) || !$cardOnFile}
										disabled="disabled"
									{/if}
									{if !$hasRemoteInput}onclick="hideNewCardInputFields();"{/if}
									value="{$cardInfo.paymethodid}"
							>
						</div>
						<div class="card-item-icon" data-paymethod-id="{$cardInfo.paymethodid}">
							<div for="existingCard{$cardInfo.paymethodid}">
								<i class="{$payMethod->getFontAwesomeIcon()} fa-fw bigger-150"></i>
							</div>
						</div>
						<div class="card-item-name"  data-paymethod-id="{$cardInfo.paymethodid}">
							<div for="existingCard{$cardInfo.paymethodid}">
								{$payMethod->payment->getDisplayName()}
							</div>
							<div for="existingCard{$cardInfo.paymethodid}">
								{if $payMethod->getDescription()}
									<span class="small text-muted">{$payMethod->getDescription()}</span>
								{else}
									-
								{/if}
							</div>
						</div>

						<div class="card-item-status text-muted" data-paymethod-id="{$cardInfo.paymethodid}">
							<div for="existingCard{$cardInfo.paymethodid}">
								{$expiryDate}
								{if $payMethodExpired}<br><small>{lang key='clientareaexpired'}</small>{else}<br><span class="label status status-{$payMethod->getStatus()|lower}">{$payMethod->getStatus()}</span>{/if}
							</div>
						</div>

					</label>
				{/foreach}
			</div>
		</div>
	</div>
{/if}
<div class="paymethod-info">
    <label class="py-2 px-3 border rounded w-100">
        <input id="newCCInfo" type="radio" class="icheck-button" name="ccinfo" value="new" {if $payMethodId eq "new" || !$cardOnFile} checked{/if} /> {lang key='creditcardenternewcard'}
    </label>
</div>
