{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

<div class="section">
	<div class="TM-card search-card bg-checkered">
		<form role="form" method="post" action="{routePath('download-search')}">
			<div class="input-group input-group-lg kb-search">
				<input type="text" name="search" id="inputDownloadsSearch" class="form-control" placeholder="{$LANG.downloadssearch}" value="{$search}" />
				<span class="input-group-append">
					<input type="submit" id="btnDownloadsSearch" class="btn btn-primary btn-input-padded-responsive" value="{$LANG.search}" />
				</span>
			</div>
		</form>
	</div>
</div>



{if $dlcats}
	<div class="section">
		<h4>{$LANG.knowledgebasecategories}</h4>
		<div class="kbcat">
			<div class="row">
				{foreach $dlcats as $category}
					<div class="col-sm-6">
						<a class="kb-article" href="{routePath('download-by-cat', {$category.id}, {$category.urlfriendlyname})}">
							<i class="far fa-folder-open"></i> {$category.name} ({lang key="downloads.numDownload{if $kbcat.numarticles != 1}s{/if}" num=$category.numarticles})
							{if $category.description}
								<p>{$category.description}</p>
							{/if}
						</a>						
					</div>
				{foreachelse}
					<div class="col-sm-12">
						<p class="text-center fontsize3">{$LANG.downloadsnone}</p>
					</div>
				{/foreach}
			</div>
		</div>
	</div>
{/if}

<div class="section">
	<h4>{$LANG.downloadsfiles}</h4>
	<div class="list-group">
		{foreach $downloads as $download}
			{if $loggedin}
				<a href="{$download.link}" class="list-group-item list-group-item-action">
					<strong>
						<i class="fas fa-download"></i>
						{$download.title}
					</strong>
					<br>
					{$download.description}
					<br>
					<small>{$LANG.downloadsfilesize}: {$download.filesize}</small>
				</a>
			{else}
				<a href="{$download.link}" class="list-group-item list-group-item-action"{if $download.clientsonly} data-toggle="tooltip" data-placement="top" title="{lang key='restricted'}"{/if}>
					<strong>
						<i class="fas fa-download"></i>
						{$download.title}
						{if $download.clientsonly}
							<i class="fas fa-lock text-muted"></i>
						{/if}
					</strong>
					<br>
					{$download.description}
					<br>
					<small>{$LANG.downloadsfilesize}: {$download.filesize}</small>
				</a>
			{/if}
		{foreachelse}
			<span class="list-group-item text-center">
				{$LANG.downloadsnone}
			</span>
		{/foreach}
	</div>
</div>

