{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}


{include file="$template/includes/tablelist.tpl" tableName="EmailsList" noSortColumns="-1" filterColumn="1"}

<script>
    jQuery(document).ready( function () {
        var table = jQuery('#tableEmailsList').show().DataTable();
        {if $orderby == 'date'}
            table.order(0, '{$sort}');
        {elseif $orderby == 'subject'}
            table.order(1, '{$sort}');
        {/if}
        table.draw();
        jQuery('#tableLoading').hide();
    });
</script>

<div class="table-container clearfix">
    <table id="tableEmailsList" class="datatable table table-hover w-hidden">
        <thead>
            <tr>
                <th data-class="expand">{$LANG.clientareaemailssubject}</th>
				<th data-hide="phone,tablet">{$LANG.clientareaemailsdate}</th>
                <th>&nbsp;</th>
            </tr>
        </thead>
        <tbody>
            {foreach $emails as $email}
            <tr onclick="popupWindow('viewemail.php?id={$email.id}', 'emailWin', '800', '600')">
                <td>{$email.subject}{if $email.attachmentCount > 0} <i class="fal fa-paperclip"></i>{/if}</td>
                <td><span class="w-hidden">{$email.normalisedDate}</span>{$email.date}</td>
                <td class="col-small center">
					<div class="action-buttons">
						<a href="#" class="text-nowrap" data-toggle="tooltip" title="{lang key='emailviewmessage'}" onclick="popupWindow('viewemail.php?id={$email.id}', 'emailWin', '800', '600', 'scrollbars=1,')">
						   <i class="fal fa-search-plus"></i>
						</a>
					</div>
				</td>
            </tr>
            {/foreach}
        </tbody>
    </table>
    <div class="text-center" id="tableLoading">
        <p><i class="fas fa-spinner fa-spin"></i> {$LANG.loading}</p>
    </div>
</div>
