{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if !$addfundsdisabled}    
	<p class="text-muted">{lang key='addfundsdescription'}</p>
{/if}

{if $addfundsdisabled}
    {include file="$template/includes/alert.tpl" type="error" msg=$LANG.clientareaaddfundsdisabled textcenter=true}
{elseif $notallowed}
    {include file="$template/includes/alert.tpl" type="error" msg=$LANG.clientareaaddfundsnotallowed textcenter=true}
{elseif $errormessage}
    {include file="$template/includes/alert.tpl" type="error" errorshtml=$errormessage textcenter=true}
{/if}

{if !$addfundsdisabled}

<div class="card">
	<div class="card-body">
		<form method="post" action="{$smarty.server.PHP_SELF}?action=addfunds">
			<fieldset>
				<div class="form-group">
					<label for="paymentmethod" class="col-form-label">{lang key='orderpaymentmethod'}:</label><br/>
					<select name="paymentmethod" id="paymentmethod" class="form-control custom-select">
						{foreach $gateways as $gateway}
							<option value="{$gateway.sysname}">{$gateway.name}</option>
						{/foreach}
					</select>
				</div>
				<div class="form-group">
					<label for="amount" class="col-form-label">{lang key='addfundsamount'}:</label>
					<div class="input-group">
						<input type="text" name="amount" id="amount" value="{$amount}" class="form-control" required />
						<div class="input-group-append">
							<button type="submit" class="btn btn-primary btn-block">
								{lang key='addfunds'}
							</button>
						</div>
					</div>
				</div>
			</fieldset>
		</form>
	</div>
</div>

<p class="text-muted"><i class="far fa-info-circle text-warning"></i> {lang key='addfundsnonrefundable'}</p>

{/if}
