/*!
//Description: //Core scripts to handle the entire theme// This file should be included in all pages
 !**/
 
jQuery(document).ready(function() {
	//Tooltips Function
	//--------------------------------
	jQuery(function () {
		jQuery("[data-rel='tooltip']").tooltip()
	});
	
    // Popover Function
	//--------------------------------
    jQuery("[data-toggle=popover]").popover({html:true});
			
	//accordion Function
	//--------------------------------
	jQuery('.card-faqs-group .collapse').on('show.bs.collapse hide.bs.collapse', function(e) {
		var id = $(this).attr('id');
		var isShowing = e.type === 'show';
		jQuery('button[data-target="#' + id + '"]')
			.closest('.card')
			.toggleClass('accordion-active', isShowing)
			.find('.card-icon').html(isShowing ? '<i class="fal fa-angle-down"></i>' : '<i class="fal fa-angle-right"></i>');
	});

	jQuery('.block-footer .collapse').on('shown.bs.collapse', function(){
		jQuery(this).parent().find(".fa-angle-right").removeClass("fa-angle-right").addClass("fa-angle-down");
		}).on('hidden.bs.collapse', function(){
		jQuery(this).parent().find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-right");
	});

	//Pricing Tables accordion Function
	//--------------------------------
	
	jQuery('.cros-pricing-container .PriceList-toggle').on('click', function () {
		jQuery('.cros-pricing-container .plan-features').collapse('toggle');
	});
	
	jQuery('select.location-switcher').on('change', function () {
		jQuery(':selected', this).tab('show');
	});

    /* toggle function */
    jQuery(".toggle").on("click",function(){
        var elm = $("#"+jQuery(this).data("toggle"));
        if(elm.is(":visible"))
            elm.addClass("d-none").removeClass("show");
        else
            elm.addClass("show").removeClass("d-none");
        
        return false;
    });
	
	/* Theme Swicther functions function */
	if(localStorage.getItem('cThemeMode'))
		{
			jQuery('body').addClass('dark-mode gray_logos');
			jQuery('.cThemeSwitcher').prop('checked', true);
		}
			
	jQuery('.cThemeSwitcher').click( function(){
		if (this.checked) {
			jQuery('body').addClass('dark-mode gray_logos');
			var cThemeMode = 'dark-mode gray_logos';
		} else if (!this.checked) {
			jQuery('body').removeClass('dark-mode gray_logos');
			var cThemeMode = '';
		}
		localStorage.setItem('cThemeMode', cThemeMode);
	});
	
	// Scroll Function for Sidebar
	jQuery(function () {	
		function setHeight() {
			windowHeight = $(window).height();
				if (jQuery(window).width() < 991) {
					jQuery('.sidebar-scroll').css('max-height', windowHeight - 110);
				}
				else {
						if (jQuery(".navbar-side").hasClass("fixed")) {
							jQuery('.sidebar-scroll').css('max-height', windowHeight - 110);
						} else {
							jQuery('.sidebar-scroll').css('max-height', 5000);
						}
				}
		};
		setHeight(); 
		jQuery(window).resize(function() {
			setHeight();
		});
				
		jQuery('.sidebar-scroll').slimScroll({
			height: '100%',
			width: '100%',
			wheelStep: 20,
			size: '14px'
		});
	});
	
    /* toggle function for sidebar responsive */
	jQuery('#navbar-side-toggle').click(function() {
		jQuery(this).toggleClass('display');
		jQuery('#navbar-side').toggleClass('display');
	});
	
    jQuery('.panel-sidebar .truncate').each(function () {
        jQuery(this).attr('title', jQuery(this).text())
            .attr('data-toggle', 'tooltip')
            .attr('data-placement', 'bottom');
    });
	
	// For WHMCS only	
	jQuery("#Secondary_Navbar-Account .dropdown-menu").addClass("dropdown-user");
	
	// Copyright removal
	jQuery("p:contains('Powered by')").remove();
	
	
	// Chekbox panel
    var panelSwitch = $('.panel-switch');
    
    panelSwitch.on('click', function (e) {
        if (!jQuery(this).is('a')) {
            var currCheck = $(this).find('input[type="checkbox"]');
             if (currCheck.is(':checked')) {
                 panelSwitch.removeClass('checked');
                 currCheck.prop('checked', false);
            } else {
                    panelSwitch.addClass('checked');
                    currCheck.prop('checked', true);
                }
                var that = $(this);
                setTimeout(function () {
                    that.find('.loader').addClass('loading');
                }, 300);
            }
    });
	
	//back top top
	jQuery(window).scroll(function () {
       if (jQuery(this).scrollTop() > 50) {
               jQuery('#back-to-top').fadeIn();
           } else {
                jQuery('#back-to-top').fadeOut();
            }
       });
       // scroll body to 0px on click
        jQuery('#back-to-top').click(function () {
            jQuery('body,html').animate({
                scrollTop: 0
            }, 800);
            return false;
        });	
		
	//for side menu simple search if you wish can impliment this option as per your choice
	jQuery(function() {    
        jQuery('#input-items').on('keyup', function() {
          var rex = new RegExp($(this).val(), 'i');
            jQuery('.side-nav li').hide();
            jQuery('.side-nav li').filter(function() {
                return rex.test($(this).text());
            }).show();
        });
    });	
	
	// enable side menu arrow
	jQuery(function() {
		jQuery('#side').crosMenu();
	})
	
	// Section Overlap functions
    jQuery('.section-overlap').each(function() {
        var $currentSection = $(this);
        var $nextSection = $currentSection.nextAll('div').first();

        if ($nextSection.length) {
            $nextSection.addClass('margin-up');
        }
    });

    $('.btn_loader').on('click', function(e) {
      var $this = $(this);
      if ($this.hasClass('loading')) {
        return; // Do nothing if already loading
      }
      $this.addClass('btn_loading disabled');
      $this.append('<span class="btn_loading_icon"><span class="spanner"><span></span><span></span><span></span><span></span></span></span>');
      
      // Simulate a delay or asynchronous action
      setTimeout(function() {
        $this.removeClass('btn_loading disabled');
        $this.find('.btn_loading_icon').remove();
      }, 3000); // Adjust the delay time as needed
    });
	
	jQuery(function() {
		jQuery('.page-scroll').bind('click', function(event) {
			var $anchor = jQuery(this);
			var offset = 100;
			if (window.innerWidth <= 768) { 
				offset = 50;
			}
			jQuery('html, body').stop().animate({
				scrollTop: jQuery($anchor.attr('href')).offset().top - offset
			}, 1000, 'swing');
			event.preventDefault();
		});
	});	
	
	$('.counter').each(function() {
		const el = this;
		if (isInViewport(el)) {
			startCounter(el);
		}
	});

	$(window).on('scroll', function() {
		$('.counter').each(function() {
			const el = this;
			if (isInViewport(el) && !$(el).hasClass('counted')) {
				startCounter(el);
				$(el).addClass('counted');
			}
		});
	});

	$('#enableSoundButton').on('click', function () {
		const container = $(this).closest('.banner-content-container');
		const video = $(this).closest('[class^="col-"]').find('.banner-bg-video')[0];

		if (video) {
			if (video.muted) {
				video.muted = false;
				video.play();
				$(this).find('.btn-text').text('Click to Mute');
				$(this).find('.fas').removeClass('fa-volume-mute').addClass('fa-volume-up');
			} else {
				video.muted = true;
				$(this).find('.btn-text').text('Click for Sound');
				$(this).find('.fas').removeClass('fa-volume-up').addClass('fa-volume-mute');
			}
		}
	});

});

// Custom function to handle smooth counter animation
function startCounter(el) {
	const dataCount = $(el).attr('data-count');
	const regex = /(\d+)(\D*)/;
	const matches = dataCount.match(regex);
	const target = parseInt(matches[1], 10);
	const text = matches[2] || '';
	let count = 0; 
	let step = target / 100;

	function animateCounter() {
		count += step; 
		$(el).text(Math.round(count) + text);

		if (count < target) {
			requestAnimationFrame(animateCounter);
		} else {
			$(el).text(target + text);
		}
	}
	animateCounter();
}

// Function to check if element is in the viewport
function isInViewport(el) {
	const rect = el.getBoundingClientRect();
	return rect.top >= 0 && rect.bottom <= window.innerHeight;
}

// side menu arrow function
// Source https://github.com/onokumus/metisMenu

;(function ($, window, document, undefined) {

    var pluginName = "crosMenu",
        defaults = {
            toggle: true
        };
        
    function Plugin(element, options) {
        this.element = element;
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    Plugin.prototype = {
        init: function () {

            var $this = $(this.element),
                $toggle = this.settings.toggle;

            $this.find('li.open').has('ul').children('ul').addClass('collapse show');
            $this.find('li').not('.open').has('ul').children('ul').addClass('collapse');

            $this.find('li').has('ul').children('a').on('click', function (e) {
                e.preventDefault();

                $(this).parent('li').toggleClass('open').children('ul').collapse('toggle');

                if ($toggle) {
                    $(this).parent('li').siblings().removeClass('open').children('ul.show').collapse('hide');
                }
            });
        }
    };

    $.fn[ pluginName ] = function (options) {
        return this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
    };

})(jQuery, window, document);

// Loader
jQuery(window).on('load', function () {
   jQuery('#overlay').fadeOut("slow");
});


// function collapse the navbar on scroll.
var Apps = function () {
	return {
        init: function () {
            // init variables require in footer
			handleNavTopBar();
        },		
		initNavTopBar: function (els) {
			if (window.matchMedia("(min-width: 992px)").matches) {
				var sbody = $('body').innerHeight();
				if (sbody > 1080) {
					//jQuery(window).scroll(function() {
					jQuery(window).on("load resize scroll",function(e){
						if (jQuery("body,html").scrollTop() > 50) {
							jQuery("body").addClass("top-nav-collapse");
							jQuery(".cros-navbar").addClass("navbar-fixed-top animated slideInDown");
						} else {
							jQuery("body").removeClass("top-nav-collapse");
							jQuery(".cros-navbar").removeClass("navbar-fixed-top animated slideInDown");
						}
					});
				}
			}
        },
	};
}();

/*!
//end
 !**/