{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if count($announcements) > 3 }
{if !$prevpage}
<script>
	$(document).ready(function(){
		$('.annuncement-item:nth-child(1), .annuncement-item:nth-child(2)').addClass('latest col-md-6');
		$('.annuncement-item:nth-child(1)').addClass('last');
	});
</script>
{/if}
{/if}

{if $announcements}
	<div class="TM-card annoucements">
		{if !$themesettings.general.bannerstyle}
			<div class="d-flex align-items-center justify-content-between heading mb-5 pb-3 border-bottom">
				<h1 class="h4 fw-900 mb-2">{lang key="announcementstitle"}</h1>
				<p class="small text-muted d-none d-sm-block mb-0 mb-sm-2">{lang key="allthelatest"} {$companyname}</p>
			</div>
		{/if}
		<div class="row">
			{foreach $announcements as $announcement}

				<div class="annuncement-item col-12" onclick="clickableSafeRedirect(event, '{routePath('announcement-view', $announcement.id, $announcement.urlfriendlytitle)}')">
					<p class="announcement-date">{$carbon->createFromTimestamp($announcement.timestamp)->format('jS M Y')}</p>
					<h2 class="h3">{$announcement.title}</h2>
					<div class="annuncement-body">
						{if $announcement.text|strip_tags|strlen < 350}
							<p>{$announcement.text}</p>
						{else}
							<p>{$announcement.summary}</p>
						{/if}
					</div>
				  
					<div class="annuncement-footer">
						<div class="btn-group">
							<span class="btn btn-xs btn-link">{lang key="readmore"} <i class="far fa-arrow-right"></i></span>
							{if $announcement.editLink}
								<a href="{$announcement.editLink}" class="btn btn-xs btn-primary">
									<i class="fal fa-edit fa-fw"></i>{$LANG.edit}
								</a>
							{/if}
						</div>
						
						 <div class="announcement-details">
							{*{if $announcementsFbRecommend}
								<div class="fb-like hidden-sm hidden-xs" data-layout="standard" data-href="{fqdnRoutePath('announcement-view', $announcement.id, $announcement.urlfriendlytitle)}" data-send="true" data-width="450" data-show-faces="true" data-action="recommend"></div>
								<div class="fb-like hidden-lg hidden-md" data-layout="button_count" data-href="{fqdnRoutePath('announcement-view', $announcement.id, $announcement.urlfriendlytitle)}" data-send="true" data-width="450" data-show-faces="true" data-action="recommend"></div>
							{/if}*}
						 </div>
					</div>
				</div>
			{/foreach}
		</div>
		{if $prevpage || $nextpage}
			<nav aria-label="Announcements navigation">
				<ul class="pagination">
					{foreach $pagination as $item}
						<li class="page-item{if $item.disabled} disabled{/if}{if $item.active} active{/if}">
							<a class="page-link" href="{$item.link}">{$item.text}</a>
						</li>
					{/foreach}
				</ul>
			</nav>
		{/if}
	</div>

{else}

	{include file="$template/includes/alert.tpl" type="info" msg="{$LANG.noannouncements}" textcenter=true}

{/if}

{if $announcementsFbRecommend}
    <script>
        (function(d, s, id) {
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) {
                return;
            }
            js = d.createElement(s); js.id = id;
            js.src = "//connect.facebook.net/{$LANG.locale}/all.js#xfbml=1";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    </script>
{/if}

