{include file="$template/includes/flashmessage.tpl"}

{if $errorMessageHtml}
    {include file="$template/includes/alert.tpl" type="error" errorshtml=$errorMessageHtml}
{/if}

<script type="text/javascript" src="{$BASE_PATH_JS}/StatesDropdown.js"></script>

<h4>{$LANG.clientareachoosecontact}</h4>

<form class="form-horizontal" role="form" method="post" action="{routePath('account-contacts')}">
	<div class="TM-card">
		<div class="row">
				<div class="col-sm-6">
					<select name="contactid" id="inputContactId" onchange="submit()" class="form-control">
						{foreach $contacts as $contact}
							<option value="{$contact.id}"{if $contact.id eq $contactid} selected="selected"{/if}>{$contact.name} - {$contact.email}</option>
						{/foreach}
						<option value="new">{$LANG.clientareanavaddcontact}</option>
					</select>
				</div>
			<div class="col-sm-2 hidden-xs">
				<button type="submit" class="btn btn-primary btn-block">{$LANG.go}</button>
			</div>
		</div>
	</div>
</form>



<form role="form" method="post" action="{routePath('account-contacts-save')}">
    <input type="hidden" name="contactid" value="{$contactid}" />
	
	<h4>{$LANG.orderForm.personalInformation}</h4>
	<div class="TM-card">
		<div class="row">
			<div class="col-sm-6">
				<div class="form-group">
					<label for="inputFirstName" class="control-label">{$LANG.clientareafirstname}</label>
					<input type="text" name="firstname" id="inputFirstName" value="{$formdata.firstname}" class="form-control" />
				</div>
			</div>
			<div class="col-sm-6">
				<div class="form-group">
					<label for="inputLastName" class="control-label">{$LANG.clientarealastname}</label>
					<input type="text" name="lastname" id="inputLastName" value="{$formdata.lastname}" class="form-control" />
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-sm-6">
				<div class="form-group">
					<label for="inputEmail" class="control-label">{$LANG.clientareaemail}</label>
					<input type="email" name="email" id="inputEmail" value="{$formdata.email}" class="form-control" />
				</div>
			</div>
			<div class="col-sm-6">
				<div class="form-group">
					<label for="inputPhone" class="control-label">{$LANG.clientareaphonenumber}</label>
					<input type="tel" name="phonenumber" id="inputPhone" value="{$formdata.phonenumber}" class="form-control" />
				</div>
			</div>
		</div>
	</div>
	
	<h4>{$LANG.orderForm.billingAddress}</h4>
	<div class="TM-card">
        <div class="form-group">
           <label for="inputCompanyName" class="control-label">{$LANG.clientareacompanyname}</label>
           <input type="text" name="companyname" id="inputCompanyName" value="{$formdata.companyname}" class="form-control" />
        </div>
		
		<div class="row">
			<div class="col-sm-6">
				<div class="form-group">
					<label for="inputAddress1" class="control-label">{$LANG.clientareaaddress1}</label>
					<input type="text" name="address1" id="inputAddress1" value="{$formdata.address1}" class="form-control" />
				</div>
			</div>
			<div class="col-sm-6">
				<div class="form-group">
					<label for="inputAddress2" class="control-label">{$LANG.clientareaaddress2}</label>
					<input type="text" name="address2" id="inputAddress2" value="{$formdata.address2}" class="form-control" />
				</div>
			</div>
		</div>
		
		<div class="row">
			<div class="col-sm-6">
				<div class="row">
					<div class="col-sm-6">
						<div class="form-group">
							<label for="inputCity" class="control-label">{$LANG.clientareacity}</label>
							<input type="text" name="city" id="inputCity" value="{$formdata.city}" class="form-control" />
						</div>
					</div>
					<div class="col-sm-6">
						<div class="form-group">
							<label for="inputState" class="control-label">{$LANG.clientareastate}</label>
							<input type="text" name="state" id="inputState" value="{$formdata.state}" class="form-control" />
						</div>
					</div>
				</div>
			</div>
			<div class="col-sm-6">
				<div class="row">
					<div class="col-sm-6">
						<div class="form-group">
							<label for="inputPostcode" class="control-label">{$LANG.clientareapostcode}</label>
							<input type="text" name="postcode" id="inputPostcode" value="{$formdata.postcode}" class="form-control" />
						</div>
					</div>
					<div class="col-sm-6">
						<div class="form-group">
							<label class="control-label" for="country">{$LANG.clientareacountry}</label>
							{$countriesdropdown}
						</div>
					</div>
				</div>
			</div>
		</div>
        <div class="form-group">
            <label for="inputTaxId" class="control-label">{lang key=$taxIdLabel}</label>
            <input type="text" name="tax_id" id="inputTaxId" class="form-control" value="{$formdata.tax_id}" />
        </div>
	</div>	
	
	<h4>{$LANG.clientareacontactsemails}</h4>
	<div class="TM-card">
		<div class="form-group">
			<div class="controls checkbox">
				{foreach $formdata.emailPreferences as $emailType => $value}
					<label>
					<input type="hidden" name="email_preferences[{$emailType}]" value="0">
					<input type="checkbox" name="email_preferences[{$emailType}]" id="{$emailType}emails" value="1"{if $value} checked="checked"{/if} />
					{lang key="clientareacontactsemails"|cat:$emailType}
					</label>{if !($emailType@last)}<br />{/if}
				{/foreach}
			</div>
		</div>
	</div>

    <div class="form-actions">
        <input class="btn btn-primary" type="submit" name="save" value="{$LANG.clientareasavechanges}" />
        <input class="btn btn-default" type="reset" value="{$LANG.cancel}" />
        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#modalDeleteContact">{lang key='clientareadeletecontact'}</button>
    </div>

</form>

<form method="post" action="{routePath('account-contacts-delete')}">
    <input type="hidden" name="contactid" value="{$contactid}">
    <div class="modal fade" id="modalDeleteContact">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header panel-heading">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><i class="fas fa-times"></i></span></button>
                    <h4 class="modal-title">
                        {lang key="clientareadeletecontact"}
                    </h4>
                </div>
                <div class="modal-body">
                    <p>{lang key="clientareadeletecontactareyousure"}</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        {lang key="cancel"}
                    </button>
                    <button type="submit" class="btn btn-primary" id="btnCancelInviteConfirm">
                        {lang key="confirm"}
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>
