class texteditor {
    static get toolbox() {
        return {
            title: 'Text/HTML Editor',
            icon: '<i class="fas fa-text"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            content: {
                b: true,
                bold: true,
                strong: true,
                iframe: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
                em: true,
                del: true,
                blockquote: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('a-editor');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Text/HTML Editor<a class="sec-docs" href="https://docs.thememetro.com/#Sec-HTMLEditor" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="sec_groups">
				<div class="form-group">
					<label>Section Layout</label>
					<select type="select" class="form-control blocklayout">
						<option value="">Container</option>
						<option value="1">Full Width</option>
					</select>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Background Type</label>
							<select type="select" class="form-control blockbgcolor">
								<option value="">None</option>
								<option value="light">Light</option>
								<option value="dark">Dark</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Border</label>
							<select type="select" class="form-control blockborders">
								<option value="">None</option>
								<option value="border-top">Top Border</option>
								<option value="border-bottom">Bottom Border</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Top</label>
							<select type="select" class="form-control blocktheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Bottom</label>
							<select type="select" class="form-control blockbheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
				</div>
				<div class="simginput">					 
					<div class="form-group">
						<label>Background Image</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-blockbgimg" class="form-control blockbgimg" value="" />
							<span onclick="PageGraphics('${this.data.id}-blockbgimg')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>
					</div>					  
				</div>
			</div>
			<textarea class="aeditortext"></textarea>
		</div>
	</div>
</div>`);

        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const blocktheight = this.data && this.data.btheight ? this.data.btheight : "";
        $(wrapper).find(".blocktheight").val(blocktheight);
        const blockbheight = this.data && this.data.bbheight ? this.data.bbheight : "";
        $(wrapper).find(".blockbheight").val(blockbheight);
        const blocklayout = this.data && this.data.blayouts ? this.data.blayouts : "";
        $(wrapper).find(".blocklayout").val(blocklayout);		
        const blockbgimg = this.data && this.data.sbimg ? this.data.sbimg : "";
        $(wrapper).find(".blockbgimg").val(blockbgimg);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
		//
        if ($(wrapper).find('.blockbgcolor').val() !== '') {
			$(wrapper).find('.simginput').addClass('hidden');
        } else {
            $(wrapper).find('.simginput').removeClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() !== '') {
                $(wrapper).find('.simginput').addClass('hidden');
            } else {
                $(wrapper).find('.simginput').removeClass('hidden');
            }
        });
		//
		
		$(wrapper).find(".aeditortext").summernote({
			dialogsInBody: true,
			height: 350,
			spellCheck: false,
			disableGrammar: true,
			codemirror: {
				theme: "material",
				mode: "text/html",
				htmlMode: !0,
				lineNumbers: !0,
				lineWrapping: !0
			},
			callbacks: {
				onFocus: function() {
					var $editor = $(this);
					if (!datastr) {
						if ($editor.summernote('isEmpty')) {
							$editor.next(".note-editor").find(".note-editable").html("");
						}
						return;
					}
					if ($editor.summernote('isEmpty')) {
						$editor.summernote('code', datastr);
					}
				},
				onChange: function(contents, $editable) {
					if (!datastr) return;
					if ($(this).summernote('isEmpty')) {
						$(this).summernote('code', datastr);
					}
				}
			}
		});
		
		// Initialize the datastr with decoded content or fallback to an empty string
		var datastr = (this.data && this.data.content ? this.data.content : '');
		var base64regex = /^([0-9a-zA-Z+/]{4})*(([0-9a-zA-Z+/]{2}==)|([0-9a-zA-Z+/]{3}=))?$/;
		// Decode if the data is base64 encoded
		try {
			if (base64regex.test(datastr)) {
				datastr = Base64.decode(datastr);
			} 
		} catch (e) {
			datastr;
		}
		
		// Set the editor content initially
		$(wrapper).find(".aeditortext").summernote('code', datastr);


        // Overwrite pasteConfig and onPaste
        wrapper.addEventListener('paste', (event) => {
            event.stopPropagation(); // Prevent Editor.js from handling the paste
        });

        $(wrapper).find(".aeditortext").on('paste', (event) => {
            event.preventDefault();
            const clipboardData = event.originalEvent.clipboardData || window.clipboardData;
            const pastedData = clipboardData.getData('text/html') || clipboardData.getData('text/plain');

            // Insert the pasted content directly into the Trumbowyg editor
            $(wrapper).find(".aeditortext").summernote('execCmd', { cmd: 'insertHTML', param: pastedData });
        });

        return wrapper;
    }

    save(blockContent) {
        var data = $(blockContent).find(".aeditortext").summernote('code');
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
        return {
			"id": this.data.id,
            "content": Base64.encode(data),
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "btheight": $(blockContent).find(".blocktheight").val(),
            "bbheight": $(blockContent).find(".blockbheight").val(),
            "blayouts": $(blockContent).find(".blocklayout").val(),
            "sbimg": $(blockContent).find(".blockbgimg").val(),
			"sechidden": sechidden
        };
    }
}