class banner {
    static get toolbox() {
        return {
            title: 'Banner',
            icon: '<i class="fas fa-sliders-h"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            code: {
                b: true,
                bold: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            },
            table: {
                b: true,
                bold: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('banner-block');
        $(wrapper).append(`<div class="register-form">
    <div class="form">
        <div class="section_header">
			<label>Banner<a class="sec-docs" href="https://docs.thememetro.com/#Sec-Banner" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>
        </div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
        <div class="form-content llbld">		
			<div style="margin: 10px 0;">
				<div class="vjsGrid"></div>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">When enabled, the banner slider will automatically start playing.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success sautoplay" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">Overlay section below on this screen.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success secoverlay" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>
			</div>
        </div>
    </div>
</div>
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit Item</h4>
            </div>
            <div class="modal-body" style="padding:30px;">			
				<div class="heading">
					<h5>Banner Description</h5>
				</div>
				<div class="well">
					<div class="form-group">
						<label>Caption</label>
						<input type="text" class="form-control caption">
					</div>
					<div class="form-group">
						<label>Title</label>
						<input type="text" class="form-control title">
					</div>
					<div class="form-group">
						<label>Subtitle</label>
						<textarea type="text" rows="3" class="form-control subtitle"></textarea>
					</div>
				</div>
				<div class="heading">
					<h5>Banner Display Type</h5>
				</div>
				<div class="well">
					<div class="form-group">
						<label>Banner Type</label>
						<select type="select" class="form-control bannertype">
							<option value="">Type 1 - Two-column banner with left or right-aligned graphics</option>
							<option value="1">Type 2 - Centered single column without graphics</option>
						</select>
					</div>
				</div>				
				<div class="bannergraphicpanel">
					<div class="heading">
						<h5>Banner Graphic</h5>
					</div>
					<div class="well">
						<div class="form-group">
							<label>Graphic</label>
							<input type="imagelib" class="form-control graphic" placeholder="">
						</div>
					   <div class="form-group">
						   <label>Graphic Position</label>
							 <select type="select" class="form-control graphicposition">
								<option value="">Right</option>
								<option value="1">Left</option>
							 </select>
					   </div>					
					</div>
				</div>				
				<div class="heading">
					<h5>Banner Background</h5>
				</div>
				<div class="well">
                   <div class="form-group">
                       <label>Background Type</label>
					     <select type="select" class="form-control bannerbg">
					        <option value="">None</option>
						    <option value="bg-primary">Primary</option>
							<option value="dark">Dark</option>
							<option value="light">Light</option>
							<option value="graphics">Graphic</option>
					     </select>
                   </div>
                   <div class="simginput">
					<div class="form-group">
						<label>Background Graphic</label>
						<input type="imagelib" class="form-control bannergraphic">
					</div>
					 <div class="row">
					   <div class="col-sm-6">
                         <div class="form-group">
                          <label>Opacity</label>
					       <select type="select" class="form-control bgopacity">
					        <option value="">Dark</option>
						    <option value="1">Light</option>
						    <option value="2">None</option>
					       </select>
                         </div>
					   </div>
					   <div class="col-sm-6">
                         <div class="form-group">
                          <label>Text Color</label>
					       <select type="select" class="form-control textcolor">
					         <option value="">Light</option>
						      <option value="text-dark">Dark</option>
					       </select>
                         </div>
					   </div>					   
					 </div>
				   </div>
				   <hr />
					 <div class="row">
						<div class="col-md-4">
							<div class="form-group">
								<label>Border</label>
								<select type="select" class="form-control blockborders">
									<option value="">None</option>
									<option value="border-top">Top Border</option>
									<option value="border-bottom">Bottom Border</option>
								</select>
							</div>
						</div>
						<div class="col-md-4">
							<div class="form-group">
								<label>Padding Top</label>
								<select type="select" class="form-control blocktheight">
									<option value="">Default</option>
									<option value="1">60px</option>
									<option value="2">30px</option>
									<option value="3">No Space</option>
								</select>
							</div>
						</div>
						<div class="col-md-4">
							<div class="form-group">
								<label>Padding Bottom</label>
								<select type="select" class="form-control blockbheight">
									<option value="">Default</option>
									<option value="1">60px</option>
									<option value="2">30px</option>
									<option value="3">No Space</option>
								</select>
							</div>
						</div>
					 </div>
				</div>			
				<div class="collapsed_panel">
					<div class="heading collapsed" data-toggle="collapse">
						<h5>Banner Action</h5>
						<button type="button" class="heading_btn">
							<span class="heading_btn_text">Expand</span>
							<span class="heading_btn_text">Hide</span>
							<span class="fal fa-angle-down"></span>
						</button>
					</div>
					<div class="well collapse">
						<div class="form-group">
							<label>Button Text</label>
							<input type="text" class="form-control itembtntext" />
						</div>
						<div class="form-group">
							<label>Button Link Type</label>
							<select type="select" class="form-control linktype">
								<option value="">Custom URL</option>
								<option value="1">Page Manager</option>
								<option value="2">Product Group</option>
								<option value="3">Product</option>
							</select>
						</div>
						<div class="curl">
							<div class="form-group">
								<label>Link To</label>
								<input type="text" class="form-control bsblink" placeholder="add custom URL..">
							</div>
						</div>
						<div class="purl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control pagelink">${cmsPages}</select>
							</div>
						</div>
						<div class="gurl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control grouplink">${groupSelect}</select>
							</div>
						</div>
						<div class="pdurl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control productlink">${productsSelect}</select>
							</div>
						</div>
						<div class="form-group">
							<div class="flex-checkbox">
							  <span class="control-label">Display starting price of selected product/product group.</span>
							  <label class="switch">
								<input type="checkbox" class="success displaypricing">
								<span class="slider round"></span>
							  </label>
							</div>
						</div>
						<div class="groupPanel">
							<div class="form-group">
								<label></label>
								<select type="select" class="form-control groupprice">${allServices}</select>
							</div>
						</div>							
					</div>
				</div>
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);
				
        if (this.data.autoplay === true) {
            $(wrapper).find('.sautoplay').attr('checked', 'checked');
        }        
		if (this.data.SecOverlay === true) {
            $(wrapper).find('.secoverlay').attr('checked', 'checked');
        }
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the banner <b> \"" + args.item.Title + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
			rowRenderer: function(item) {
				var $cButtons = $("<td>").addClass("jsgrid-cell jsgrid-control-field jsgrid-align-center").attr("width", "50px").append($("<button>").addClass("jsgrid-button jsgrid-delete-button").attr("type", "button").attr("title", "Delete"));
				
				$cButtons.on("click", function() {
					showDetailsDialog("Delete", {});
				});
				
				var banner = item;
				var $info = banner.Title;
				
				return $("<tr>")
					.append($("<td>").addClass("jsgrid-cell grid-info-block jsgrid-align-left").attr("width", "400px").append($info))
					.append($cButtons);
			},			
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {title: "Banners", width: 400},
                {type: "control", width: 50,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                                .addClass(cls)
                                .attr({
                                    type: "button",
                                    title: tooltip
                                })
                                .on("click", function (e) {
                                    //clickHandler(grid, e);
                                    showDetailsDialog("Add", {});
                                });
                    },

                    editValue: function () {
                        return "";
                    }
					
                } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;
		var sectionId = this.data?.id || "";

        var showDetailsDialog = function (dialogType, banner, itemIndex) {
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "banner_new_" : "banner_" + itemIndex;
			
			if (isNew) {
				banner = {
					Caption: '',
					Title: '',
					SubTitle: '',
					Type: '',
					displayPricing: 0,
					Group: '',
					Plan: '',
					bannerGraphic: '',
					LinkType: '',
					Graphic: '',
					GraphicPosition: '',
					bannerBg: '',
					TextColor: '',
					bgOpacity: '',
					Border: '',
					TopPadding: '',
					BottomPadding: '',					
					btnText: '',
					Link: ''
				};
			}
			
			$(wrapper).find('input[type="imagelib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageGraphics(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageGraphics('" + uniqueId + "')");
				}
			});
			
			$(wrapper).find('.modal-body .collapsed_panel').each(function (index, element) {
				var uniqueId = sectionId + "_heading_" + index;
				var $panel = $(element);
				var $heading = $panel.find('.heading');
				var $well = $panel.find('.well');
				
				if ($heading.length) {
					$heading.attr("aria-controls", uniqueId);
					$heading.attr("href", "#" + uniqueId);
				}
				if ($well.length && $well.hasClass('collapse')) {
					$well.attr("id", uniqueId);
				}
				
				$well.removeClass('in');
				$heading.addClass('collapsed');				
				
			});

			$(wrapper).find(".caption").val(banner.Caption);
            $(wrapper).find(".title").val(banner.Title);
            $(wrapper).find(".bannertype").val(banner.Type);
            $(wrapper).find(".bannergraphic").val(banner.bannerGraphic);
			$(wrapper).find(".itembtntext").val(banner.btnText);
            $(wrapper).find(".linktype").val(banner.LinkType);
			$(wrapper).find(".graphic").val(banner.Graphic);
			$(wrapper).find(".bannerbg").val(banner.bannerBg);
			$(wrapper).find(".textcolor").val(banner.TextColor);
			$(wrapper).find(".bgopacity").val(banner.bgOpacity);
			$(wrapper).find(".graphicposition").val(banner.GraphicPosition);
			$(wrapper).find(".blockborders").val(banner.Border);
			$(wrapper).find(".blocktheight").val(banner.TopPadding);
			$(wrapper).find(".blockbheight").val(banner.BottomPadding);
			$(wrapper).find(".displaypricing").prop('checked', banner.displayPricing ? true : false);

			if (banner.Group && banner.Group !== '') {
				$(wrapper).find(".groupprice").val(`gid=${banner.Group}`);
			} else if (banner.Plan && banner.Plan !== '') {
				$(wrapper).find(".groupprice").val(`pid=${banner.Plan}`);
			} else {
				$(wrapper).find(".groupprice").val('');
			}

			$(wrapper).find(".groupprice").select2().trigger("change");

			$(wrapper).find(".groupprice").on("change", function() {
				var selectedValue = $(this).val();

				if (selectedValue) {
					if (selectedValue.startsWith('gid=')) {
						banner.Group = selectedValue.split('=')[1];
						banner.Plan = '';
					} else if (selectedValue.startsWith('pid=')) {
						banner.Plan = selectedValue.split('=')[1];
						banner.Group = '';
					}
				} else {
					banner.Group = '';
					banner.Plan = '';
				}
			});
			
			$(wrapper).find('.modal').off('shown.bs.modal').on('shown.bs.modal', function () {
				var modalId = $(this).attr('id');
				var $SubTitle = $('#' + modalId).find('.subtitle');

				if (!$SubTitle.next('.trumbowyg-box ').length) {
					$SubTitle.trumbowyg({
						semantic: false,
						btns: [
							['strong', 'em', 'del', 'underline'],
							['unorderedList', 'orderedList'],
							['viewHTML']
						],
					});
				}
				$SubTitle.trumbowyg('html', banner.SubTitle);
			});
			
			$(wrapper).find(".displaypricing").each(function() {
				var checkboxId = uniqueIDPrefix + "_dp";
				var panelClass = ".groupPanel";

				$(this).attr("id", checkboxId);

				$(this).on("change", function() {
					let isChecked = this.checked;
					$(panelClass).toggleClass("hidden", !isChecked, {
						duration: 300
					});
				}).trigger("change");
			});
			
			const select2Elements = [
				{ selector: ".pagelink", placeholder: 'Select a page' },
				{ selector: ".productlink", placeholder: 'Select a product' },
				{ selector: ".grouplink", placeholder: 'Select a products group' },
				{ selector: ".groupprice", placeholder: 'Select a product or group' }
			];

			select2Elements.forEach(function(item) {
				$(wrapper).find(item.selector).select2({
					placeholder: item.placeholder,
					allowClear: true
				});
			});

			
			function updateLinkFields() {
				var linkType = $(wrapper).find('.linktype').val();

				switch (linkType) {
					case '':
						$(wrapper).find(".bsblink").val(banner.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
					case '1':
						$(wrapper).find(".pagelink").val(banner.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".grouplink").val('');
						break;
					case '2':
						$(wrapper).find(".grouplink").val(banner.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					case '3':
						$(wrapper).find(".productlink").val(banner.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".grouplink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					default:
						$(wrapper).find(".bsblink").val(banner.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
				}
			}

			
			updateLinkFields();

			$(wrapper).find('.linktype').on('change', function () {
				//banner.LinkType = $(this).val();
				updateLinkFields();
			});
			
			//
			if ($(wrapper).find('.bannerbg').val() === 'graphics') {
				$(wrapper).find('.simginput').removeClass('hidden');
			} else {
				$(wrapper).find('.simginput').addClass('hidden');
			}
			$(wrapper).find('.bannerbg').on('change', function () {
				if ($(wrapper).find('.bannerbg').val() === 'graphics') {
					$(wrapper).find('.simginput').removeClass('hidden');
				} else {
					$(wrapper).find('.simginput').addClass('hidden');
				}
			});

			if ($(wrapper).find('.bannertype').val() === '1') {
				$(wrapper).find('.bannergraphicpanel').addClass('hidden');
			} else {
				$(wrapper).find('.bannergraphicpanel').removeClass('hidden');
			}
			$(wrapper).find('.bannertype').on('change', function () {
				if ($(wrapper).find('.bannertype').val() === '1') {
					$(wrapper).find('.bannergraphicpanel').addClass('hidden');
				} else {
					$(wrapper).find('.bannergraphicpanel').removeClass('hidden');
				}
			});
			
			//
			
			//
			function LinkInputsVisibility() {
				const linktypeVal = $(wrapper).find('.linktype').val();
				const LinkInputs = {
					curl: $(wrapper).find('.curl'),
					purl: $(wrapper).find('.purl'),
					pdurl: $(wrapper).find('.pdurl'),
					gurl: $(wrapper).find('.gurl')
				};
				Object.values(LinkInputs).forEach(el => el.addClass('hidden'));

				switch (linktypeVal) {
					case '':
						LinkInputs.curl.removeClass('hidden');
						break;
					case '1':
						LinkInputs.purl.removeClass('hidden');
						break;
					case '2':
						LinkInputs.gurl.removeClass('hidden');
						break;
					case '3':
						LinkInputs.pdurl.removeClass('hidden');
						break;
				}
			}
			LinkInputsVisibility();
			$(wrapper).find('.linktype').on('change', LinkInputsVisibility);
			//
		
            formSubmitHandler = function () {
                savebanner(banner, dialogType === "Add");
            };
            $(wrapper).find(".modal").modal('show');
        };
        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .title").val() === '') {
				alert('Title is required for banner');
				e.preventDefault();
			} else {
				formSubmitHandler();
			}
        });
        var savebanner = function (banner, isNew) {
			var linkType = $(wrapper).find('.linktype').val();
			var linkValue;
			switch (linkType) {
				case '':
					linkValue = $(wrapper).find(".bsblink").val();
					break;
				case '1':
					linkValue = $(wrapper).find(".pagelink").val();
					break;
				case '2':
					linkValue = $(wrapper).find(".grouplink").val();
					break;
				case '3':
					linkValue = $(wrapper).find(".productlink").val();
					break;
				default:
					linkValue = $(wrapper).find(".bsblink").val();
					break;
			}

			// Determine if it's Group or Plan
			var groupPriceVal = $(wrapper).find(".groupprice").val();
			
			if (groupPriceVal !== null) {
				if (groupPriceVal.includes("gid=")) {
					banner.Group = parseInt(groupPriceVal.replace("gid=", ""));
				} else if (groupPriceVal.includes("pid=")) {
					banner.Plan = parseInt(groupPriceVal.replace("pid=", ""));
				}
			}			
			
            $.extend(banner, {
				Caption: $(wrapper).find(".caption").val(),
                Title: $(wrapper).find(".title").val(),
                SubTitle: $(wrapper).find(".subtitle").val(),
                Type: $(wrapper).find(".bannertype").val(),
                bannerGraphic: $(wrapper).find(".bannergraphic").val(),
                btnText: $(wrapper).find(".itembtntext").val(),
                LinkType: $(wrapper).find(".linktype").val(),
				Graphic: $(wrapper).find(".graphic").val(),
				GraphicPosition: $(wrapper).find(".graphicposition").val(),
				Border: $(wrapper).find(".blockborders").val(),
				TopPadding: $(wrapper).find(".blocktheight").val(),
				BottomPadding: $(wrapper).find(".blockbheight").val(),
				bannerBg: $(wrapper).find(".bannerbg").val(),
				TextColor: $(wrapper).find(".textcolor").val(),
				bgOpacity: $(wrapper).find(".bgopacity").val(),
				Link: linkValue,
				displayPricing: $(wrapper).find(".displaypricing").is(':checked')
				
            });
			
            $(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", banner);
            $(wrapper).find(".modal").modal('hide');
        };
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
        var status = $(blockContent).find(".sautoplay").is(':checked');
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var SecOverlay = $(blockContent).find(".secoverlay").is(':checked');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
			"type": $(blockContent).find(".bannertype").val(),
            "autoplay": status,
            "SecOverlay": SecOverlay,
			"sechidden": sechidden 
        };
    }
}