class PricePanel {
    static get toolbox() {
        return {
            title: 'Product Groups',
            icon: '<i class="fas fa-server"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            featured: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            },
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Product Groups<span class="sec-docs text-danger" href="#" data-container="body" data-toggle="popover" data-trigger="hover" data-html="true" data-content="This section will be removed in the upcoming release. You will need to migrate the contents into the <strong>Product Group</strong> section.">Deprecated</span></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control sectiontitle" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>				
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
						<select type="select" class="form-control blockbgcolor">
						<option value="">None</option>
						<option value="light">Light</option>
					</select>
				</div>
				<div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					</select>
				</div>
			</div>
			<div class="heading">
				<h5>Product Group Type</h5>
			</div>			
			<div class="sec_groups">
				<div class="form-group">
					<label>Select Display Type</label>
						<select type="select" class="form-control grouptype">
						<option value="">Type 1 - Group with big price and "Learn More" button</option>
						<option value="1">Type 2 - Group with link style button</option>
					</select>
				</div>
			</div>
			<div class="heading collapsed" data-toggle="collapse" href="#${this.data.id}-1">
				<h5>Product Group Settings</h5>
				<button type="button" class="heading_btn">
					<span class="heading_btn_text">Expand</span>
					<span class="heading_btn_text">Hide</span>
					<span class="fal fa-angle-down"></span>
				</button>
			</div>
			<div id="${this.data.id}-1" class="collapse">
				<div class="sec_groups">
					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
								<label>Groups Background Color</label>
								<select type="select" class="form-control gtablebgcolor">
									<option value="">None</option>
									<option value="light">Light</option>
									<option value="primary">Primary</option>
									<option value="dark">Dark</option>
								</select>
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group">
								<label>list count</label>
								<input type="text" class="form-control laitems" value="" />
							</div>
						</div>
					</div>
					<div class="form-group">
						<label>Featured Text</label>
						<input type="text" class="form-control wsinput" placeholder="i.e., Most Popular" value="" />
						<span class="help-block">You can set a single featured banner text for all product groups if you prefer not to create separate banner texts for each group.</span>
					</div>
					<div class="form-group">
						<label>Group features List Style</label>
						<select type="select" class="form-control fechecklist">
							<option value="">None</option>
							<option value="check-list">Check</option>
							<option value="check-circle">Check Circle</option>
							<option value="check-square">Check Square</option>
							<option value="arrows">Arrow</option>
						</select>
					</div>
				</div>
				<div class="sec_groups">
					<div class="form-group">
						<div class="flex-checkbox">
							<span class="control-label">When enabled, all groups will be displayed centered.</span>
							<label class="switch">
								<input type="checkbox" class="form-control success centered" />
								<span class="slider round"></span>
							</label>
						</div>
					</div>				
					<div class="form-group">
						<div class="flex-checkbox">
							<span class="control-label">Display product groups on grid instead of slider.</span>
							<label class="switch">
								<input type="checkbox" class="form-control success displayingrid" />
								<span class="slider round"></span>
							</label>
						</div>
					</div>
					<div class="SliderOptions">
						<div class="form-group">
							<select type="select" class="form-control slidertype">
								<option value="">Slider with dots or bullet indicators at the bottom</option>
								<option value="1">Slider with "left" and "right" navigation arrows</option>
							</select>
						</div>
					</div>					
					<div class="form-group">
						<div class="flex-checkbox">
							<span class="control-label">Disable the auto-collapse option for the group features list on small devices.</span>
							<label class="switch">
								<input type="checkbox" class="form-control success collapsed_option" />
								<span class="slider round"></span>
							</label>
						</div>
					</div>					
					<div class="form-group">
						<div class="flex-checkbox">
							<span class="control-label">When enabled, the shadow effect will be disabled for the groups.</span>
							<label class="switch">
								<input type="checkbox" class="form-control success boxshadow" />
								<span class="slider round"></span>
							</label>
						</div>
					</div>
				</div>
			</div>
			<div style="margin-top: 10px;">
				<div class="vjsGrid"></div>
			</div>
		</div>
	</div>
</div>
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit product group</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
                <div class="form-group">
                    <label>Product Group</label>
					<select type="select" class="form-control groups">${groupSelect}</select>
                </div>
				<div class="form-group">
					<label>Graphic for this group</label>
					<input type="medialib" class="form-control groupgraphics">
				</div>
                <div class="form-group">
					<div class="flex-checkbox">
					  <span class="control-label">Enable this if you want display a featured banner on this group.</span>
                      <label class="switch">
					    <input type="checkbox" class="success featured">
						<span class="slider round"></span>
					  </label>
					</div>
                </div>
				<div class="well feauredPanel">
					<div class="form-group">
						<label>Featured Text</label>
						<input type="text" class="form-control featuredtext" placeholder="Get FREE WHMCS" />
					</div>
					<div class="form-group">
						<label>Featured Sticker Style</label>
						<select type="select" class="form-control featuredstyle">
							<option value="0">Type 1</option>
							<option value="1">Type 2</option>
						</select>
					</div>
				</div>
				<div class="heading">
					<h5>Action Button</h5>
				</div>
				<div class="well">
					<div class="form-group">
						<label>Button Text</label>
						<input type="text" class="form-control itembtntext" />
					</div>
					<div class="form-group">
						<label>Button Link Type</label>
						<select type="select" class="form-control linktype">
							<option value="">Custom URL</option>
							<option value="1">Page Manager</option>
						</select>
					</div>
					<div class="curl">
						<div class="form-group">
							<label>Link To</label>
							<input type="text" class="form-control grouplink" placeholder="add custom URL..">
						</div>
					</div>
					<div class="purl">
						<div class="form-group">
							<label>Link To</label>
							<select type="select" class="form-control pagelink">${cmsPages}</select>
						</div>
					</div>
				</div>
            </div>
			<div class="modal-footer">
				<button type="button" class="btn btn-primary savedataid">Submit</button> 
			</div>
		</div>
	</div>
</div>`);

        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const gtablebgcolor = this.data && this.data.gtablebg ? this.data.gtablebg : "";
        $(wrapper).find(".gtablebgcolor").val(gtablebgcolor);
        const stickerstyle = this.data && this.data.ststyle ? this.data.ststyle : "";
        $(wrapper).find(".stickerstyle").val(stickerstyle);
        const fechecklist = this.data && this.data.flisticon ? this.data.flisticon : "";
        $(wrapper).find(".fechecklist").val(fechecklist);
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "3";
        $(wrapper).find(".laitems").val(laitems);
        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);		
        const sectiontitle = this.data && this.data.sectitle ? this.data.sectitle : "";
        $(wrapper).find(".sectiontitle").val(sectiontitle);
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);
		const slidertype = this.data && this.data.slidertype ? this.data.slidertype : "";
        $(wrapper).find(".slidertype").val(slidertype);		
        const grouptype = this.data && this.data.grouptype ? this.data.grouptype : "";
        $(wrapper).find(".grouptype").val(grouptype);
        if (this.data.noshadow === true) {
            $(wrapper).find('.boxshadow').attr('checked', 'checked');
        }
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		if (this.data.featurescollapsed === true) {
            $(wrapper).find('.collapsed_option').attr('checked', 'checked');
        }
        if (this.data.DisplayInGrid === true) {
            $(wrapper).find('.displayingrid').attr('checked', 'checked');
        }		
        if (this.data.centered === true) {
            $(wrapper).find('.centered').attr('checked', 'checked');
        }
        const wsinput = this.data && this.data.featured ? this.data.featured : "";
		
		$(wrapper).find(".laitems").on('input', function() {
			const value = $(this).val();
			const min = 2;
			const max = 4;
			if (/^\d+$/.test(value)) {
				const numberValue = parseInt(value, 10);
				
				if (numberValue < min || numberValue > max) {
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
						text: `Please enter a number between ${min} and ${max}.`,
						confirmButtonColor: "#c1c1c1",
						html: true,
						buttons: true,
						dangerMode: true,
					});
					$(this).val('4');
				}
			} else {
				swal({
					title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
					text: "Please enter a valid number.",
					confirmButtonColor: "#c1c1c1",
					html: true,
					buttons: true,
					dangerMode: true,
				});
				$(this).val('4'); 
			}
		});
		
		function togglePanel(switcher, panel, showOnChecked = true) {
			if ($(wrapper).find(switcher).is(':checked') === showOnChecked) {
				$(wrapper).find(panel).show();
			} else {
				$(wrapper).find(panel).hide();
			}
		}

		$(wrapper).find('.displayingrid').on('change', function() {
			togglePanel('.displayingrid', '.SliderOptions', false);
		});
		
		togglePanel('.displayingrid', '.SliderOptions', false);		

		function getGroupNameById(groups, id) {
			var group = groups.find(function(group) {
				return group.gid === id;
			});
			return group ? group.name : "Unknown Group";
		}
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					var groupId = args.item.Group;
					var groupName = getGroupNameById(bycgroups, groupId);
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the product group <b>\"" + groupName + "\"</b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {name: "Group", title: "Product Groups", type: "select", width: 400, items: bycgroups, valueField: "gid", textField: "name", align: "left", css: "grid-info-block"},
                {name: "link", type: "text", width: 200, visible: false, sorting: false},
                {name: "Featured", type: "checkbox", title: "Featured", visible: false, sorting: false},
                {name: "GroupbtnText", type: "text", title: "Button Text", visible: false, sorting: false},
                {name: "FeaturedText", title: 'Featured Banner Text', type: "text", width: 200, visible: false, sorting: false},
                {name: "StickerStyle", title: 'Sticker Style', type: "select", items: [{Name: "Default", Id: 0}, {Name: "Style 1", Id: 1}, {Name: "Style 2", Id: 2}], valueField: "Id", textField: "Name", width: 100, visible: false, sorting: false},
                //{type: "control"}
                //changed input to buttons
                {type: "control", editButton: false,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                                .addClass(cls)
                                .attr({
                                    type: "button",
                                    title: tooltip
                                })
                                .on("click", function (e) {
                                    //clickHandler(grid, e);
									showDetailsDialog("Add", {});
                                });
                    },

                    editValue: function () {
                        return "";
                    }


                } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, product, itemIndex) {
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "group_new_" : "group_" + itemIndex;
			
            if (dialogType === "Add") product = {
                Group: 0,
                Featured: 0,
				StickerStyle: 0,
				GroupbtnText: '',
				LinkType: '',
                link: '',
				Graphic: '',
				FeaturedText: ''
            };
			
			$(wrapper).find('input[type="medialib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageMedia(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageMedia('" + uniqueId + "')");
				}
			});
			
			$(wrapper).find('.modal-body .collapsed_panel').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_heading_" + index;
				var $panel = $(element);
				var $heading = $panel.find('.heading');
				var $well = $panel.find('.well');
				
				if ($heading.length) {
					$heading.attr("aria-controls", uniqueId);
					$heading.attr("href", "#" + uniqueId);
				}
				if ($well.length && $well.hasClass('collapse')) {
					$well.attr("id", uniqueId);
				}
				
				$well.removeClass('in');
				$heading.addClass('collapsed');				
				
			});
			
            $(wrapper).find(".groups").val(product.Group);
			$(wrapper).find(".featuredtext").val(product.FeaturedText);
			$(wrapper).find(".featuredstyle").val(product.StickerStyle);
			$(wrapper).find(".itembtntext").val(product.GroupbtnText);
			$(wrapper).find(".featured").prop('checked', product.Featured);
			$(wrapper).find(".linktype").val(product.LinkType);
			$(wrapper).find(".groupgraphics").val(product.Graphic);
			$(wrapper).find(".groups").select2().trigger("change");
			if ($(wrapper).find('.featuredstyle').val() === null || $(wrapper).find('.featuredstyle').val() === '0') {
				$(wrapper).find('.featuredstyle').val('0');
			}
			//
			
			$(wrapper).find(".featured").each(function() {
				var checkboxId = uniqueIDPrefix + "_featured";
				var panelClass = ".feauredPanel";

				$(this).attr("id", checkboxId);

				$(this).on("change", function() {
					let isChecked = this.checked;
					$(panelClass).toggleClass("hidden", !isChecked, {
						duration: 300
					});
				}).trigger("change");
			});

			const select2Elements = [
				{ selector: ".pagelink", placeholder: 'Select a page' },
			];
			
			select2Elements.forEach(function(item) {
				$(wrapper).find(item.selector).select2({
					placeholder: item.placeholder,
					allowClear: true
				});
			});
			
			
			function updateLinkFields() {
				var linkType = $(wrapper).find('.linktype').val();

				switch (linkType) {
					case '':
						$(wrapper).find(".grouplink").val(product.link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						break;
					case '1':
						$(wrapper).find(".pagelink").val(product.link).trigger('change');
						$(wrapper).find(".grouplink").val('');
						break;
					default:
						$(wrapper).find(".grouplink").val(product.link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						break;
				}
			}

			
			updateLinkFields();

			$(wrapper).find('.linktype').on('change', function () {
				//product.LinkType = $(this).val();
				updateLinkFields();
			});
			
			function LinkInputsVisibility() {
				const linktypeVal = $(wrapper).find('.linktype').val();
				const LinkInputs = {
					curl: $(wrapper).find('.curl'),
					purl: $(wrapper).find('.purl')
				};
				Object.values(LinkInputs).forEach(el => el.addClass('hidden'));

				switch (linktypeVal) {
					case '':
						LinkInputs.curl.removeClass('hidden');
						break;
					case '1':
						LinkInputs.purl.removeClass('hidden');
						break;
				}
			}
			LinkInputsVisibility();
			$(wrapper).find('.linktype').on('change', LinkInputsVisibility);

		
            formSubmitHandler = function () {
                saveProduct(product, dialogType === "Add");
            };

            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .groups").prop("selectedIndex") === -1) {
			  alert('Please select a Product Group from the list.');
			  e.preventDefault();
			} else {
			  formSubmitHandler();
			}
        });

        var saveProduct = function (product, isNew) {
			var linkType = $(wrapper).find('.linktype').val();
			var linkValue;
			switch (linkType) {
				case '':
					linkValue = $(wrapper).find(".grouplink").val();
					break;
				case '1':
					linkValue = $(wrapper).find(".pagelink").val();
					break;
				default:
					linkValue = $(wrapper).find(".grouplink").val();
					break;
			}
			
            $.extend(product, {
				Group: parseInt($(wrapper).find(".groups").val()),
				LinkType: $(wrapper).find(".linktype").val(),
				GroupbtnText: $(wrapper).find(".itembtntext").val(),
				Graphic: $(wrapper).find(".groupgraphics").val(),
				link: linkValue,
                FeaturedText: $(wrapper).find(".featuredtext").val(),
                StickerStyle: parseInt($(wrapper).find(".featuredstyle").val()),
				Featured: $(wrapper).find(".featured").is(':checked')
				
            });
            $(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", product);
            $(wrapper).find(".modal").modal('hide');
			
        };

        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });		
		
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(wsinput);
        }, 200);
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
        var status = $(blockContent).find(".boxshadow").is(':checked');
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var centered = $(blockContent).find(".centered").is(':checked');
		var featurescollapsed = $(blockContent).find(".collapsed_option").is(':checked');
		var DisplayInGrid = $(blockContent).find(".displayingrid").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
            "table": items,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "sectitle": $(blockContent).find(".sectiontitle").val(),			
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "ststyle": $(blockContent).find(".stickerstyle").val(),
            "flisticon": $(blockContent).find(".fechecklist").val(),
            "gtablebg": $(blockContent).find(".gtablebgcolor").val(),
            "itemcounts": $(blockContent).find(".laitems").val(),
            "featured": $(blockContent).find(".wsinput").val(),
            "grouptype": $(blockContent).find(".grouptype").val(),
			"slidertype": $(blockContent).find(".slidertype").val(),
			"subtitle": subtitle,
			"featurescollapsed": featurescollapsed,
			"DisplayInGrid": DisplayInGrid,
            "noshadow": status,
			"sechidden": sechidden,
			"centered" : centered
        };
    }
}