<?php

use WHMCS\ClientArea;
use WHMCS\Database\Capsule;

define("CLIENTAREA", true);
require __DIR__ . "/init.php";
$ca = new ClientArea();
$ca->initPage();
$filename = basename(__FILE__);
$item = adminpanel_getpagedata($filename);
if(empty($item)){
    redir("","index.php");
}
if($item->publish == "0" && $item->page_url != "index.php"){
    redir("","index.php");
}
$pagedata = adminpanel_getpagesubdata($item->id);
$pagedata["item"] = (array) $item;
require ROOTDIR . "/modules/addons/adminpanel/core/FrontPageBuilder.php";
$ca->setPageTitle($item->name);
$ca->addToBreadCrumb("index.php", Lang::trans("globalsystemname"));
$ca->addToBreadCrumb($filename, $item->name);
$pagebuilder = new FrontPageBuilder(html_entity_decode($item->description));
$pagecontent = $pagebuilder->output();
$ca->assign("pagebuilder", $pagecontent);
$ca->assign("pagedata", $pagedata);
if(!empty($pagedata["clientonly"]) && $item->page_url != "index.php"){
    $ca->requireLogin();
}
$ca->assign("skipMainBodyContainer", true);
$ca->setTemplate("pagebuilder");
$ca->output();
