{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

<div class="section">
	<div class="TM-card search-card bg-checkered">
		<form role="form" method="post" action="{routePath('knowledgebase-search')}">
			<div class="input-group input-group-lg kb-search">
				<input type="text" id="inputKnowledgebaseSearch" name="search" class="form-control" placeholder="{$LANG.howcanwehelp}" />
				<span class="input-group-append">
					<input type="submit" id="btnKnowledgebaseSearch" class="btn btn-primary btn-input-padded-responsive" value="{$LANG.search}" />
				</span>
			</div>
		</form>
	</div>
</div>

<div class="section">
	{if $kbcats}
		<h4>{$LANG.knowledgebasecategories}</h4>
		<div class="kbcat">
			<div class="row">
				{foreach $kbcats as $category}
					<div class="col-xl-6">
						<div class="kb-article" onclick="clickableSafeRedirect(event, '{routePath('knowledgebase-category-view', {$category.id}, {$category.urlfriendlyname})}')">
							<i class="fal fa-folder{if $category.numarticles > 0 }-open{/if} fa-fw"></i> {$category.name}
							{if $category.numarticles > 0 }<span>({$category.numarticles})</span>{/if}
							{if $category.editLink}
								<span class="admin-edit-link"><a href="{$category.editLink}">
									<i class="fal fa-edit fa-fw"></i>{$LANG.edit}
								</a></span>
							{/if}
							{if $category.description}<p>{$category.description}</p>{/if}
						</div>
					</div>
				{/foreach}
			</div>
		</div>
	{else}
		{include file="$template/includes/alert.tpl" type="info" msg=$LANG.knowledgebasenoarticles textcenter=true}
	{/if}
</div>

{if $kbmostviews}
	<div class="section">
		<h4>{$LANG.knowledgebasepopular}</h4>
		<div class="kbarticles">
			{foreach from=$kbmostviews item=kbarticle}
				<div class="kb-article" onclick="clickableSafeRedirect(event, '{routePath('knowledgebase-article-view', {$kbarticle.id}, {$kbarticle.urlfriendlytitle})}')">
					<span class="far fa-file-alt fa-fw"></span>{$kbarticle.title} {if $kbarticle.editLink} <span class="admin-edit-link"><a href="{$kbarticle.editLink}"><i class="fal fa-edit fa-fw"></i>{$LANG.edit}</a></span>{/if}
					<p>{$kbarticle.article|truncate:100:"..."}</p>
				</div>
			{/foreach}
		</div>
	</div>
{/if}
