<!DOCTYPE html>
<html lang="{$activeLocale.languageCode}">
<head>
<meta charset="{$charset}" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
{if $templatefile eq "pagebuilder" or $templatefile eq "homepage"}
<title>{if $pagedata.meta_title}{$pagedata.meta_title}{else}{$pagedata.item.name} - {$companyname}{/if}</title>
{elseif $inShoppingCart && $templatefile == 'products'}
<title>{$productGroup.name} - {$companyname}</title>
{elseif $inShoppingCart && $templatefile == 'domainregister'}
<title>{lang key="domainregistration"} - {$companyname}</title>
{elseif $inShoppingCart && $templatefile == 'domaintransfer'}
<title>{lang key='transferdomain'} - {$companyname}</title>
{else}
<title>{if $templatefile == 'viewannouncement'}{$title}{elseif $templatefile == 'announcements'}{lang key="announcementstitle"}{elseif $kbarticle.title}{$kbarticle.title}{elseif $templatefile == 'knowledgebasecat'}{$kbcurrentcat.name}{else}{$pagetitle}{/if} - {$companyname}</title>
{/if}

{if $templatefile eq "pagebuilder" or $templatefile eq "homepage"}
{if $pagedata.meta_keyword}<meta name="keywords" content="{$pagedata.meta_keyword}" />{/if}	
{if $pagedata.meta_description}<meta name="description" content="{$pagedata.meta_description}" />{/if}

{if $themesettings.seotools.fbappid}
<meta property="fb:app_id" content="{$themesettings.seotools.fbappid}" />
{/if}

{if $pagedata.meta_title}
<meta property="og:title" content="{$pagedata.meta_title}" />
<meta property="og:url" content="{$systemsslurl}{if $templatefile neq 'homepage'}{if $pagedata.item.page_seo}{$pagedata.item.page_seo}{else}{$pagedata.item.page_url}{/if}{/if}" />
{/if}
{if $pagedata.meta_description}
<meta property="og:description" content="{$pagedata.meta_description}" />
{/if}
{if $pagedata.banner_of}
<meta property="og:image" content="{if $pagedata.banner_of|strstr:"https"}{else}{$systemurl}assets/{/if}{$pagedata.banner_of}" />
{/if}
{if $pagedata.og_type}
<meta property="og:type" content="{$pagedata.og_type}" />
{/if}
{if $pagedata.meta_title}
<meta name="twitter:title" content="{$pagedata.meta_title}" />
{/if}
{if $pagedata.meta_description}
<meta name="twitter:description" content="{$pagedata.meta_description}" />
{/if}
{if $pagedata.banner_of}
<meta name="twitter:image" content="{if $pagedata.banner_of|strstr:"https"}{else}{$systemurl}assets/{/if}{$pagedata.banner_of}" />
{/if}

{if $smarty.server.REQUEST_URI|strstr:"language" || $smarty.server.REQUEST_URI|strstr:"currency"}
<meta name="robots" content="noindex,nofollow" />
	
{else}
	{if $pagedata.robots neq "1"}<meta name="robots" content="noindex,nofollow" />{/if}
{/if}



{if $themesettings.seotools.globalschema}
<!-- WebSite & Organization Schema -->
<script type="application/ld+json">
{
 "@context": "https://schema.org",
 "@graph": [
    {
      "@type":"Organization",
      "name":"{if $themesettings.seotools.orgname}{$themesettings.seotools.orgname}{else}{$companyname}{/if}",
      "url": "{$systemurl}",
      "logo":"{if $themesettings.seotools.ologo}{$themesettings.seotools.ologo}{else}{$themesettings.general.logourl}{/if}",
      {if $themesettings.seotools.PostalAddress}
      "address" : {
          "@type": "PostalAddress",
          "addressLocality": "{$themesettings.seotools.addressLocality}",
          "postalCode": "{$themesettings.seotools.postalCode}",
          "streetAddress": "{$themesettings.seotools.streetAddress}",
          "addressRegion": "{$themesettings.seotools.addressRegion}"
      },
	  {/if}
      "contactPoint" : {
          "@type" : "ContactPoint",
          {if $themesettings.seotools.phonenumber}"telephone" : "{$themesettings.seotools.phonenumber}",{/if}
		  
		  {if $themesettings.seotools.contactemail}"email" : "{$themesettings.seotools.contactemail}",{/if}
		  
          "contactType" : "{if $themesettings.seotools.contactType}{$themesettings.seotools.contactType}{else}Customer Service{/if}"
      },
	  
      "sameAs" : [
	  {if $themesettings.seotools.SocialMedia}
          "{$themesettings.seotools.FacebookURL}",
          "{$themesettings.seotools.TwitterURL}",
          "{$themesettings.seotools.instagramURL}",
          "{$themesettings.seotools.linkedinURL}",
          "{$themesettings.seotools.YouTubeURL}"
	   {/if}
      ]
    },
	
    {
        "@type": "WebSite",
        "name":"{if $pagedata.meta_title}{$pagedata.meta_title}{else}{$pagedata.item.name} - {$companyname}{/if}",
        "url": "{$systemurl}"
    }
 ]
}
</script>
<!-- End of WebSite & Organization Schema -->
{/if}

{else}

{if $smarty.server.REQUEST_URI|strstr:"language" || $smarty.server.REQUEST_URI|strstr:"currency" || $showingLoginPage}
<meta name="robots" content="noindex,nofollow" />
{/if}

{/if}

{if $themesettings.seotools.googlevcode}
<meta name="google-site-verification" content="{$themesettings.seotools.googlevcode}" />
{/if}
{if $themesettings.seotools.bingvcode}
<meta name="baidu-site-verification" content="{$themesettings.seotools.bingvcode}" />
{/if}
{if $themesettings.seotools.yandexvcode}
<meta name="msvalidate.01" content="{$themesettings.seotools.yandexvcode}" />
{/if}
{if $themesettings.seotools.baiduvcode}
<meta name="yandex-verification" content="{$themesettings.seotools.baiduvcode}" />
{/if}

{include file="$template/includes/head.tpl"}
	
{if $themesettings.favicon.enablefavicon}
<link rel="icon" type="image/png" href="{$themesettings.favicon.faviconurl}" />
{/if}

{$headoutput}

</head>
<body class="{if $themesettings.general.themelayout eq '1'}{if $templatefile eq "order" && $themesettings.orderform.opcnoheader} mt-0{/if}{if $themesettings.headersetting.navsticky} left-layout{else}{/if}{/if}{if $themesettings.customcolors.darkmode == '1'} dark-mode{if $themesettings.customcolors.dmimggs != '1'} gray_logos{/if}{/if}{if $themesettings.general.noradius > '0'} no-radius{/if}{if $themesettings.general.cdepth < '1'} c-depth{/if}{if $themesettings.headersetting.hdepth < '1'} h-depth{/if}{if $themesettings.footersetting.fdepth < '1'} f-depth{/if}{if $themesettings.headersetting.enablepreheader} pre-header-enabled{/if}{if $showingLoginPage} login{if $themesettings.clientarea.loginbg != ""} {$themesettings.clientarea.loginbg}{/if}{/if}{if $templatefile == 'order' && $themesettings.orderform.opcnoheader} spc{/if}{if $templatefile == 'order' && $themesettings.orderform.opcnofooter} spcnofooter{/if}"{if $showingLoginPage}{if $themesettings.clientarea.loginbg != "no-img"}{if $themesettings.clientarea.loginbgimg} style="background-image:url('{$themesettings.clientarea.loginbgimg}');"{/if}{/if}{/if} data-phone-cc-input="{$phoneNumberInputStyle}">
{if $captcha}{$captcha->getMarkup()}{/if}
{if !$showingLoginPage}
{$headeroutput}

{if $themesettings.general.nopreloader}
<div id="overlay">
	<div class="spanner">
		<div></div>
		<div></div>
		<div></div>
		<div></div>
	</div>
</div>
{/if}  

{if $themesettings.general.themelayout == "1"}
{include file="$template/core/layouts/left/header.tpl"}
{else}
{include file="$template/core/layouts/default/header.tpl"}
{/if}

{/if}