{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $domains}
{if $warnings}
    {include file="$template/includes/alert.tpl" type="warning" msg=$warnings textcenter=true}
{/if}

<div class="tab-content">
    <div class="tab-pane fade show active" id="tabOverview">
        {include file="$template/includes/tablelist.tpl" tableName="DomainsList" noSortColumns="0, 5" startOrderCol="1" filterColumn="4"}

        <script>
            jQuery(document).ready( function () {
                var table = jQuery('#tableDomainsList').show().DataTable();
                {if $orderby == 'domain'}
                    table.order(1, '{$sort}');
                {elseif $orderby == 'nextduedate'}
                    table.order(2, '{$sort}');
                {elseif $orderby == 'autorenew'}
                    table.order(3, '{$sort}');
                {elseif $orderby == 'status'}
                    table.order(4, '{$sort}');
                {/if}
                table.draw();
                jQuery('#tableLoading').hide();
				
				jQuery('.domids').iCheck({
					checkboxClass: 'icheckbox_square-blue',
				});
            });
        </script>
		
        <form id="domainForm" method="post" action="clientarea.php?action=bulkdomain">
            <input id="bulkaction" name="update" type="hidden" />

			<div class="btn-group btn-group-sm mb-3" role="group">
				<button type="button" class="btn btn-default setBulkAction" id="nameservers">
					<i class="fal fa-globe fa-fw"></i>
					{lang key='domainmanagens'}
				</button>
				{if $allowrenew && !$themesettings.orderform.orderopc}
					<button type="button" class="btn btn-default setBulkAction" id="renewDomains">
						<i class="fal fa-sync"></i>
						{lang key='domainmassrenew'}
					</button>
				{/if}
				<div class="btn-group btn-group-sm" role="group">
					<button id="btnGroupDrop1" type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
						 {lang key="more"}...
					</button>
					<div class="dropdown-menu dropdown-menu-right" aria-labelledby="btnGroupDrop1">
						{* <a class="dropdown-item setBulkAction" href="#" id="contactinfo"><i class="fal fa-user"></i> {lang key='domaincontactinfoedit'}</a> *}
						<a class="dropdown-item setBulkAction" href="#" id="autorenew"><i class="fal fa-sync"></i> {lang key='domainautorenewstatus'}</a>
						<a class="dropdown-item setBulkAction" href="#" id="reglock"><i class="fal fa-lock"></i> {lang key='domainreglockstatus'}</a>
					</div>
				</div>
			</div>
				
            <div class="table-container clearfix">	
				<div class="table-header">
					<label>{lang key='view'}</label>
					<div class="dropdown view-filter-btns">
						<button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							<span>{lang key='domainRenewal.showAll'}</span>						
						</button>
						 <ul class="dropdown-menu" role="menu" aria-labelledby="dropdownMenuButton">
							<li><a href="#" class="dropdown-item"><span data-value="all">{lang key='domainRenewal.showAll'}</span></a></li>
							{foreach key=statustext item=count from=$domains|@array_column:'statustext'|@array_count_values}
								<li><a href="#" class="dropdown-item"><span data-value="{$statustext}">{$statustext}</span></a></li>
                            {/foreach}
						</ul>
					</div>		
				</div>
				
                <table id="tableDomainsList" class="datatable table table-hover w-hidden">
                    <thead>
                        <tr>
                            <th class="col-small center" data-class="expand"></th>
                            <th>{lang key='orderdomain'}</th>
                            <th data-hide="phone,tablet">{lang key='clientareahostingregdate'}</th>
                            <th data-hide="phone,tablet">{lang key='nextdue'}</th>
                            {* <th data-hide="phone,tablet">{$LANG.domainsautorenew}</th> *}
                            <th data-hide="phone">{lang key='domainstatus'}</th>
                            <th>&nbsp;</th>
                        </tr>
                    </thead>
                    <tbody>
                    {foreach key=num item=domain from=$domains}
                        <tr onclick="clickableSafeRedirect(event, 'clientarea.php?action=domaindetails&amp;id={$domain.id}', false)">
                            <td class="col-small center">
                                <input type="checkbox" name="domids[]" class="domids stopEventBubble" value="{$domain.id}" />
                            </td>
                            <td>
								<div class="ssl-info" data-element-id="{$domain.id}" data-type="domain" data-domain="{$domain.domain}">
									{if $domain.sslStatus}
										<img src="{$domain.sslStatus->getImagePath()}" data-toggle="tooltip" title="{$domain.sslStatus->getTooltipContent()}" class="{$domain.sslStatus->getClass()}"/>
									{elseif !$domain.isActive}
										<img src="{$BASE_PATH_IMG}/ssl/ssl-inactive-domain.png" data-toggle="tooltip" title="{lang key='sslState.sslInactiveDomain'}">
									{/if}
								</div>
								<a class="text-small" href="https://{$domain.domain}" target="_blank">{$domain.domain}</a>
								
								<br />
								<small>
                                {if $domain.autorenew}
                                    <i class="fas fa-fw fa-check text-success"></i> {lang key='domainsautorenew'}
                                {else}
                                    <i class="fas fa-fw fa-times text-danger"></i> {lang key='domainsautorenew'}
                                {/if}
								</small>								
							</td>
                            <td><span class="w-hidden">{$domain.normalisedRegistrationDate}</span>{$domain.registrationdate}</td>
                            <td><span class="w-hidden">{$domain.normalisedNextDueDate}</span>{$domain.nextduedate}</td>
                            {* <td>
                                {if $domain.autorenew}
                                    <i class="fas fa-fw fa-check text-success"></i> {$LANG.domainsautorenewenabled}
                                {else}
                                    <i class="fas fa-fw fa-times text-danger"></i> {$LANG.domainsautorenewdisabled}
                                {/if}
                            </td> *}
                            <td>
                                <span class="label status status-{$domain.statusClass}">{$domain.statustext}</span>
                                <span class="w-hidden">
									{if $domain.expiringSoon}<span>{lang key="domainsExpiringSoon"}</span>{/if}
                                </span>
                            </td>
                            <td class="col-small center">
								<a href="#" role="button" class="btn btn-link btn-sm" data-toggle="dropdown">
									<i class="fas fa-ellipsis-h"></i>
								</a>
								<ul class="dropdown-menu dropdown-menu-right" role="menu">
									{if $domain.status eq 'Active'}
										<li><a class="dropdown-item" href="clientarea.php?action=domaindetails&id={$domain.id}#tabNameservers">{lang key="domainmanagens"}</a></li>
										<li><a class="dropdown-item" href="clientarea.php?action=domaincontacts&domainid={$domain.id}">{lang key="domaincontactinfoedit"}</a></li>
										<li><a class="dropdown-item" href="clientarea.php?action=domaindetails&id={$domain.id}#tabAutorenew">{lang key="domainautorenewstatus"}</a></li>
										<li class="dropdown-divider"></li>
									{/if}
									<li><a class="dropdown-item" href="clientarea.php?action=domaindetails&id={$domain.id}">{lang key="managedomain"}</a></li>
									{if $allowrenew}
										{if $domain.canDomainBeManaged}
											<li><a class="dropdown-item" href="{if $themesettings.orderform.orderopc}order.php?ordertype=domain_renewal&domain={$domain.domain}{else}{routePath('domain-renewal', $domain.domain)}{/if}">{lang key='domainsrenew'}</a></li>
										{else}
											<li><a class="dropdown-item disabled" href="#" onclick="return false;" class="disabled" disabled="disabled">{lang key='domainsrenew'}</a></li>
										{/if}

									{/if}
								</ul>
                            </td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
                <div class="text-center" id="tableLoading">
                    <p><i class="fas fa-spinner fa-spin"></i> {$LANG.loading}</p>
                </div>
            </div>
        </form>
    </div>
</div>

{else}
<div class="alert-lg no-data">
	<div class="icon">
		<i class="fas fa-exclamation-triangle"></i>
	</div>
	<div class="text">
		{$LANG.clientareadomainnone}
	</div>
    <a class="btn btn-primary" href="{$WEB_ROOT}/cart.php?a=add&domain=register">
       {$LANG.orderregisterdomain}
    </a>
</div>
{/if}
