class peoplecomments {
    static get toolbox() {
        return {
            title: 'Testimonials',
            icon: '<i class="fas fa-users"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            },
            subtitle: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Testimonials<a class="sec-docs" href="https://docs.thememetro.com/#Sec-Testimonials" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
				   <label>Title</label>
				   <input type="text" class="form-control wsinput" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>				
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
						<select type="select" class="form-control blockbgcolor">
							 <option value="">None</option>
							 <option value="light">Light</option>
						</select>
				</div>
				<div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					</select>
				</div>
			</div>
			<div class="vjsGrid"></div>
		</div>
	</div>
</div>
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit Item</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
				<div class="form-group">
					<label>Name</label>
					<input type="text" class="form-control clientname">
				</div>
				<div class="form-group">
					<label>Feedback</label>
					<textarea type="text" rows="5" class="form-control clientcomment"></textarea>
				</div>
                <div class="form-group">
                    <label>Rating</label>
					<select type="select" class="form-control clientrating">
						<option value="0">None</option>
						<option value="1">5 Star</option>
						<option value="2">4 Star</option>
						<option value="3">3 Star</option>
						<option value="4">2 Star</option>
						<option value="5">1 Star</option>
					</select>
                </div>
				<div class="heading">
					<h5>Author Information</h5>
				</div>
				<div class="well">
					<div class="form-group">
						<label>Profile Image</label>
						<input type="imagelib" class="form-control clientimage">
					</div>
					<div class="form-group">
						<label>Company Name & Link</label>
						<input type="text" class="form-control companylink">
						<span class="help-block">Example <code>&lt;a href=&quot;https://example.com&quot; target=&quot;_blank&quot;&gt;Red Publicity, LLC&lt;/a&gt;</code></span>
					</div>
				</div>
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);

        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);			
		const title = this.data && this.data.title ? this.data.title : "";
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);		
		const image = this.data && this.data.image ? this.data.image : "";
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
        
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the feedback of <b> \"" + args.item["Client name"] + "\" </b> from this section.",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
			rowRenderer: function(item) {
				var $cButtons = $("<td>").addClass("jsgrid-cell jsgrid-control-field jsgrid-align-center").attr("width", "50px").append($("<button>").addClass("jsgrid-button jsgrid-delete-button").attr("type", "button").attr("title", "Delete"));
				
				$cButtons.on("click", function() {
					showDetailsDialog("Delete", {});
				});
				
				var peoplecomments = item;
				var $config = $("<div>").addClass("panel panel-default")
                .append($("<div class='panel-heading'><h3 class='panel-title'>").html("" + peoplecomments['Client name']))
				.append($("<div class='panel-body'>").html("" + peoplecomments['Client comment']));
				
				return $("<tr>")
					.append($("<td>").addClass("jsgrid-cell grid-info-block custom-grid jsgrid-align-left").attr("width", "400px").append($config))
					.append($cButtons);
			},
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {name: "Client name", title: 'Testimonials', type: "text", width: 400, align: "left", css: "grid-info-block"},
				{name: "Client Image", title: 'Profile Image Link', type: "text", visible: false, sorting: false},
                {name: "Client link", title: 'Website Link', type: "text", visible: false, sorting: false},
				{name: "Client Rating", title: 'Rating', type: "select", items: [ { Name: "None", Id: 0 }, { Name: "5 Star", Id: 1 }, { Name: "4 Star", Id: 2 }, { Name: "3 Star", Id: 3 }, { Name: "2 Star", Id: 4 }, { Name: "1 Star", Id: 5 } ], valueField: "Id", textField: "Name", visible: false, sorting: false},
                {name: "Client comment", title: 'Comments', type: "textarea", visible: false, sorting: false},
                //{type: "control"}
                //changed input to buttons
                {type: "control", editButton: false, width: 50,	
                 _createGridButton: function(cls, tooltip, clickHandler) {
                      var grid = this._grid;

                      return $("<button>").addClass(this.buttonClass)
                         .addClass(cls)
                           .attr({
                                type: "button",
                                title: tooltip
                               })
                            .on("click", function(e) {
                                //clickHandler(grid, e);
								showDetailsDialog("Add", {});
                            });
                     },

                    editValue: function() {
                       return "";
                   }				
				
				
              } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, peoplecomments, itemIndex) {
			
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "comment_new_" : "comment_" + itemIndex;

			if (isNew) {
				peoplecomments = {
					'Client name': '',
					'Client Image': '',
					'Client link': '',
					'Client Rating': '',
					'Client comment': ''
				};
			}
			
			$(wrapper).find('input[type="imagelib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageGraphics(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageGraphics('" + uniqueId + "')");
				}
			});
			
            $(wrapper).find(".clientname").val(peoplecomments['Client name']);
			$(wrapper).find(".clientimage").val(peoplecomments['Client Image']);
			$(wrapper).find(".companylink").val(peoplecomments['Client link']);
			$(wrapper).find(".clientrating").val(peoplecomments['Client Rating']);
			
			$(wrapper).find('.modal').off('shown.bs.modal').on('shown.bs.modal', function () {
				var modalId = $(this).attr('id');
				var $clientFeedback = $('#' + modalId).find('.clientcomment');

				if (!$clientFeedback.next('.trumbowyg-box ').length) {
					$clientFeedback.trumbowyg({
						semantic: false,
						btns: [
							['strong', 'em', 'del', 'underline'],
							['unorderedList', 'orderedList'],
							['viewHTML']
						],
					});
				}
				$clientFeedback.trumbowyg('html', peoplecomments['Client comment']);
			});

			//
			if ($(wrapper).find('.clientrating').val() === null || $(wrapper).find('.clientrating').val() === '0') {
				$(wrapper).find('.clientrating').val('0');
			}
			//
			
            formSubmitHandler = function () {
                savePeopleComments(peoplecomments, dialogType === "Add");
            };

            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .clientname").val() === '') {
			  alert('Name is required.');
			  e.preventDefault();
			} else if ($(".ce-block--focused .clientcomment").val() === "") {
			  alert('Comment is required.');
			  e.preventDefault();
			} else {
			  formSubmitHandler();
			}
        });

        var savePeopleComments = function (peoplecomments, isNew) {
            const updatedPeopleComments = {
                'Client name': $(wrapper).find(".clientname").val(),
				'Client Image': $(wrapper).find(".clientimage").val(),
				'Client link': $(wrapper).find(".companylink").val(),
				'Client Rating': $(wrapper).find(".clientrating").val(),
				'Client comment': $(wrapper).find(".clientcomment").val()
            };

            if (isNew) $(wrapper).find(".vjsGrid").jsGrid("insertItem", updatedPeopleComments);
            else $(wrapper).find(".vjsGrid").jsGrid("updateItem", peoplecomments, updatedPeopleComments);

            $(wrapper).find(".modal").modal('hide');
        };
		
        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });			
		
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(title);
        }, 200);          
        return wrapper;
    }

    save(blockContent) {
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "title": $(blockContent).find(".wsinput").val(),
			"subtitle": subtitle,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
			"sechidden": sechidden
        };
    }
}