class bkheader {
    static get toolbox() {
        return {
            title: 'Small Header',
            icon: '<i class="fas fa-heading"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            content: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
		wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Small Header<a class="sec-docs" href="https://docs.thememetro.com/#Sec-SmallHeader" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="sec_groups">
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control bgtitle" value=""/>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				 <div class="form-group">
					 <label>Background Type</label>
					 <select type="select" class="form-control sebgcolor">
						<option value="">Default</option>
						<option value="bg-primary">Primary</option>
						<option value="bg-light">Light</option>
						<option value="dark">Dark</option>
						<option value="bg-white">None</option>
					 </select>
				</div>
				<div class="sborderinput">
					<div class="form-group">
						<label>Border</label>
						<select type="select" class="form-control blockborders">
						  <option value="">None</option>
						  <option value="border-top">Top Border</option>
						  <option value="border-bottom">Bottom Border</option>
						</select>
						<span class="help-block">This will only apply if the section is not the first section on the page.</span>
					</div>
				</div>
				<div class="simginput">
					<div class="form-group">
						<label>Background Image</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-bgsimage" class="form-control bgsimage" value="" />
							<span onclick="PageGraphics('${this.data.id}-bgsimage')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>					
						<span class="help-block">Leave this field empty if you want to use the theme's default background image.</span>
					</div>
					 <div class="form-group">
					  <label>Backgound Opacity:</label>
					   <select type="select" class="form-control sopacity">
						 <option value="">Yes</option>
						  <option value="1">No</option>
					   </select>
					 </div>
				 </div>
			 </div>
		</div>
	</div>
</div>`);
		
        const title = this.data && this.data.title ? this.data.title : "";		
        const sebgcolor = this.data && this.data.scbg ? this.data.scbg : "";
        $(wrapper).find(".sebgcolor").val(sebgcolor);	
        const sopacity = this.data && this.data.bgOpacity ? this.data.bgOpacity : "";
        $(wrapper).find(".sopacity").val(sopacity);
        const vvimage = this.data && this.data.image ? this.data.image : "";
        $(wrapper).find(".bgsimage").val(vvimage);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }

		//
        if ($(wrapper).find('.sebgcolor').val() !== '') {
			$(wrapper).find('.simginput').addClass('hidden');
        } else {
            $(wrapper).find('.simginput').removeClass('hidden');
        }
        $(wrapper).find('.sebgcolor').on('change', function () {
            if ($(wrapper).find('.sebgcolor').val() !== '') {
                $(wrapper).find('.simginput').addClass('hidden');
            } else {
                $(wrapper).find('.simginput').removeClass('hidden');
            }
        });
		//
		
		//
        if ($(wrapper).find('.sebgcolor').val() == 'bg-light' || $(wrapper).find('.sebgcolor').val() == 'bg-white') {
			$(wrapper).find('.sborderinput').removeClass('hidden');
        } else {
            $(wrapper).find('.sborderinput').addClass('hidden');
        }
        $(wrapper).find('.sebgcolor').on('change', function () {
            if ($(wrapper).find('.sebgcolor').val() == 'bg-light' || $(wrapper).find('.sebgcolor').val() == 'bg-white') {
                $(wrapper).find('.sborderinput').removeClass('hidden');
            } else {
                $(wrapper).find('.sborderinput').addClass('hidden');
            }
        });
		//
		
        setTimeout(function () {
            $(wrapper).find(".bgtitle").val(title); 
        }, 200);          
        return wrapper;
    }

    save(blockContent) {
        var title = $(blockContent).find(".bgtitle").val();
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
        return {
			"id": this.data.id,
            "title": title,
            "scbg": $(blockContent).find(".sebgcolor").val(),
			"bgOpacity": $(blockContent).find(".sopacity").val(),
            "image": $(blockContent).find(".bgsimage").val(),
			"borders": $(blockContent).find(".blockborders").val(),
			"sechidden": sechidden
        };
    }
}