<?php

$logo = '
data:image/png;base64,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
';

?>